(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31061,       1153]
NotebookOptionsPosition[     27275,       1022]
NotebookOutlinePosition[     27990,       1048]
CellTagsIndexPosition[     27947,       1045]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Chapter 8", "Title",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[TextData[{
 StyleBox["The Lindstedt-Poincar\[EAcute] Method",
  FontSlant->"Italic"],
 " "
}], "Subtitle",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
 FontFamily->"Times New Roman"],

Cell[TextData[{
 "Suppose you have copied the package ",
 StyleBox["ODE.m ",
  FontWeight->"Bold"],
 "in the directory  c:\\ODE6. To load it, you have to type ",
 StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["Mathematica", 
    StyleBox["\[RegisteredTrademark]",
     FontWeight->"Plain"]], TraditionalForm]]],
 StyleBox[" session",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{3.476785399546875*^9},
 FontFamily->"Times New Roman",
 FontSize->12],

Cell["<<c:\\ODE6\\ODE.m", "Input",
 CellChangeTimes->{3.476769516546875*^9},
 EmphasizeSyntaxErrors->True,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 8.3 The Programs LindPoic and GLindPoinc", "Section",
 
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 8.5", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "-", 
       RowBox[{"\[Epsilon]", " ", 
        SuperscriptBox["x", "3"]}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Epsilon]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"m", "=", "2"}], ";"}], "\n"}], "\n", 
 RowBox[{"LindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "m"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"GLindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "0.1", ",", 
   RowBox[{"{", 
    RowBox[{"0.3", ",", "0.6", ",", "0.9", ",", "1.2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "50"}], "}"}]}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.6", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "-", 
       RowBox[{"\[Epsilon]", 
        RowBox[{"(", 
         RowBox[{"x", "+", 
          SuperscriptBox["y", "2"]}], ")"}]}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Epsilon]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"m", "=", "1"}], ";"}], "\n"}], "\n", 
 RowBox[{"LindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "m"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"GLindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "0.1", ",", 
   RowBox[{"{", 
    RowBox[{"0.3", ",", "0.6", ",", "0.9", ",", "1.2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "50"}], "}"}]}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.7", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "-", 
       RowBox[{"\[Epsilon]", " ", "y", 
        RowBox[{"(", 
         RowBox[{"9", "-", 
          SuperscriptBox["x", "2"]}], ")"}]}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Epsilon]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"m", "=", "1"}], ";"}], "\n"}], "\n", 
 RowBox[{"LindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "m"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"GLindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "0.08", ",", 
   RowBox[{"{", "6", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}]}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"\[Epsilon]", " ", "y", 
        RowBox[{"(", 
         RowBox[{"9", "-", 
          SuperscriptBox["x", "2"]}], ")"}]}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Epsilon]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"m", "=", "1"}], ";"}], "\n"}], "\n", 
 RowBox[{"LindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "m"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"GLindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "0.08", ",", 
   RowBox[{"{", "6", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}]}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.8", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"\[Mu]", " ", "y", 
        RowBox[{"(", 
         RowBox[{"1", "-", "x", "+", "y"}], ")"}]}]}]}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"m", "=", "1"}], ";"}], "\n"}], "\n", 
 RowBox[{"LindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "m"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.9", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"\[Mu]", 
        RowBox[{"(", 
         RowBox[{"y", "-", 
          FractionBox[
           SuperscriptBox["y", "3"], "3"]}], ")"}]}]}]}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"m", "=", "1"}], ";"}], "\n"}], "\n", 
 RowBox[{"LindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "m"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"GLindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "0.6", ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}]}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.10", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "-", 
       RowBox[{"\[Epsilon]", " ", "x", "  ", 
        SuperscriptBox["y", "2"]}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Epsilon]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"m", "=", "1"}], ";"}], "\n"}], "\n", 
 RowBox[{"LindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "m"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"GLindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "0.1", ",", 
   RowBox[{"{", 
    RowBox[{"0.3", ",", "0.5", ",", "0.8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "20"}], "}"}]}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 StyleBox[
  RowBox[{"<<", "Calculus`DSolveIntegrals`"}],
  FontSize->12]], "Input",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"DifferentialInvariants", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "==", 
      RowBox[{"y", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}], "==", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"x", "[", "t", "]"}]}], "-", 
       RowBox[{"\[Epsilon]", " ", 
        RowBox[{"x", "[", "t", "]"}], "  ", 
        SuperscriptBox[
         RowBox[{"y", "[", "t", "]"}], "2"]}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], ",", 
     RowBox[{"y", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.11", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", "y"}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "-", 
       RowBox[{"\[Epsilon]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "-", "2"}], ")"}]}]}]}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Epsilon]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"m", "=", "1"}], ";"}], "\n"}], "\n", 
 RowBox[{"LindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "m"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"GLindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "0.01", ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "1", ",", "1.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "20"}], "}"}]}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 StyleBox[
  RowBox[{"<<", "Calculus`DSolveIntegrals`"}],
  FontSize->12]], "Input",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"DifferentialInvariants", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "==", 
      RowBox[{"y", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "t", "]"}], "==", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"x", "[", "t", "]"}]}], "-", 
       RowBox[{"\[Epsilon]", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"x", "[", "t", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"y", "[", "t", "]"}], "2"], "-", "2"}], ")"}]}]}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], ",", 
     RowBox[{"y", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.12", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "'"}], "==", 
      RowBox[{"y", "-", 
       RowBox[{"\[Mu]", " ", 
        SuperscriptBox["y", "2"]}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "'"}], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"\[Mu]", " ", 
        FractionBox[
         SuperscriptBox["y", "2"], 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "-", "1"}]]}]}]}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"m", "=", "1"}], ";"}], "\n"}], "\n", 
 RowBox[{"LindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "m"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"GLindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "0.2", ",", 
   RowBox[{"{", 
    RowBox[{"0.00006", ",", "0.0002"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "50"}], "}"}]}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"CriticalEqS", "[", 
  RowBox[{"sys", ",", "unk", ",", "6"}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 8.13", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "\[Prime]",
       MultilineFunction->None], "==", 
      RowBox[{"y", "-", 
       RowBox[{"\[Mu]", " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          RowBox[{"4", 
           SuperscriptBox["y", "2"]}], "-", "4"}], ")"}]}]}]}], ",", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "-", 
       RowBox[{"\[Mu]", " ", "y", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          RowBox[{"4", 
           SuperscriptBox["y", "2"]}], "-", "4"}], ")"}]}]}]}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"m", "=", "1"}], ";"}], "\n"}], "\n", 
 RowBox[{"LindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "m"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"GLindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "0.1", ",", 
   RowBox[{"{", 
    RowBox[{"2", " ", 
     SqrtBox[
      RowBox[{"2", "/", "5"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}]}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 8.4 Problems", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "\[Prime]",
       MultilineFunction->None], "==", 
      RowBox[{"y", "+", 
       RowBox[{"\[Mu]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "x"}], "-", 
          RowBox[{"5", " ", 
           SuperscriptBox["x", "3"]}], "+", 
          SuperscriptBox["x", "5"], "-", 
          RowBox[{"5", " ", "x", " ", 
           SuperscriptBox["y", "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["x", "3"], " ", 
           SuperscriptBox["y", "2"]}], "+", 
          RowBox[{"x", " ", 
           SuperscriptBox["y", "4"]}]}], ")"}]}]}]}], ",", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"\[Mu]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "y"}], "-", 
          RowBox[{"5", " ", 
           SuperscriptBox["x", "2"], " ", "y"}], "+", 
          RowBox[{
           SuperscriptBox["x", "4"], " ", "y"}], "-", 
          RowBox[{"5", " ", 
           SuperscriptBox["y", "3"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["x", "2"], " ", 
           SuperscriptBox["y", "3"]}], "+", 
          SuperscriptBox["y", "5"]}], ")"}]}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"m", "=", "1"}], ";"}], "\n"}], "\n", 
 RowBox[{"LindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "m"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"GLindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "0.1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "5"}], "}"}]}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "\[Prime]",
       MultilineFunction->None], "==", 
      RowBox[{"y", "-", 
       RowBox[{"\[Mu]", " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "-", "4"}], ")"}]}]}]}], ",", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "-", 
       RowBox[{"\[Mu]", " ", "y", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "-", "2"}], ")"}]}]}]}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"m", "=", "1"}], ";"}], "\n"}], "\n", 
 RowBox[{"LindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "m"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"GLindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "0.2", ",", 
   RowBox[{"{", 
    SqrtBox["3"], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}]}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"GLindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", 
   RowBox[{"-", "0.2"}], ",", 
   RowBox[{"{", 
    SqrtBox["3"], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}]}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "\[Prime]",
       MultilineFunction->None], "==", 
      RowBox[{"y", "-", 
       RowBox[{"\[Mu]", " ", "y", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "-", "4"}], ")"}]}]}]}], ",", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "-", 
       RowBox[{"\[Mu]", " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "-", "2"}], ")"}]}]}]}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n"}], "\n", 
 RowBox[{"LindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "1"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"GLindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "0.1", ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "1", ",", "1.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "\[Prime]",
       MultilineFunction->None], "==", 
      RowBox[{"y", "-", 
       RowBox[{"\[Mu]", " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "-", "4"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "-", "2"}], ")"}]}]}]}], ",", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "-", 
       RowBox[{"\[Mu]", " ", "y", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "-", "4"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", 
          SuperscriptBox["y", "2"], "-", "2"}], ")"}]}]}]}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n"}], "\n", 
 RowBox[{"LindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "1"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"GLindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "0.1", ",", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox["2"], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}]}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "\[Prime]",
       MultilineFunction->None], "==", 
      RowBox[{"y", "-", 
       RowBox[{"\[Mu]", " ", 
        RowBox[{"(", 
         RowBox[{"x", "-", 
          FractionBox[
           RowBox[{"2", " ", "x"}], 
           SqrtBox[
            RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}]]], "+", 
          FractionBox[
           SuperscriptBox["x", "2"], 
           RowBox[{
            SuperscriptBox["x", "2"], "+", 
            SuperscriptBox["y", "2"]}]], "-", 
          FractionBox[
           RowBox[{"x", " ", "y"}], 
           RowBox[{
            SuperscriptBox["x", "2"], "+", 
            SuperscriptBox["y", "2"]}]]}], ")"}]}]}]}], ",", 
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "==", 
      RowBox[{
       RowBox[{"-", "x"}], "-", 
       RowBox[{"\[Mu]", "  ", 
        RowBox[{"(", 
         RowBox[{"y", "-", 
          FractionBox[
           RowBox[{"2", " ", "y"}], 
           SqrtBox[
            RowBox[{
             SuperscriptBox["x", "2"], "+", 
             SuperscriptBox["y", "2"]}]]], "+", 
          FractionBox[
           RowBox[{"x", " ", "y"}], 
           RowBox[{
            SuperscriptBox["x", "2"], "+", 
            SuperscriptBox["y", "2"]}]], "-", 
          FractionBox[
           SuperscriptBox["y", "2"], 
           RowBox[{
            SuperscriptBox["x", "2"], "+", 
            SuperscriptBox["y", "2"]}]]}], ")"}]}]}]}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "t"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"par", "=", "\[Mu]"}], ";"}], "\n"}], "\n", 
 RowBox[{"LindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "1"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[
 RowBox[{"GLindPoinc", "[", 
  RowBox[{"sys", ",", "unk", ",", "var", ",", "par", ",", "0.01", ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}]}], "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{947, 840},
WindowMargins->{{2, Automatic}, {Automatic, 5}},
DockedCells->FEPrivate`FrontEndResource[
 "FEExpressions", "CompatibilityToolbar"],
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->False,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 28, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 128, 4, 102, "Title",
 Evaluatable->False],
Cell[721, 29, 234, 9, 62, "Subtitle",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[980, 42, 61, 1, 87, "Section"],
Cell[1044, 45, 543, 17, 58, "Text"],
Cell[1590, 64, 178, 5, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1805, 74, 157, 3, 87, "Section"],
Cell[CellGroupData[{
Cell[1987, 81, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[2101, 86, 780, 28, 173, "Input"],
Cell[2884, 116, 320, 8, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3241, 129, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[3355, 134, 836, 30, 173, "Input"],
Cell[4194, 166, 320, 8, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4551, 179, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[4665, 184, 846, 30, 173, "Input"],
Cell[5514, 216, 268, 7, 35, "Input"],
Cell[5785, 225, 846, 30, 173, "Input"],
Cell[6634, 257, 268, 7, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6939, 269, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[7053, 274, 817, 30, 168, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7907, 309, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[8021, 314, 859, 32, 203, "Input"],
Cell[8883, 348, 267, 7, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9187, 360, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[9302, 365, 791, 28, 173, "Input"],
Cell[10096, 395, 308, 8, 35, "Input"],
Cell[10407, 405, 130, 4, 35, "Input"],
Cell[10540, 411, 742, 24, 41, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11319, 440, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[11434, 445, 886, 32, 173, "Input"],
Cell[12323, 479, 307, 8, 35, "Input"],
Cell[12633, 489, 130, 4, 35, "Input"],
Cell[12766, 495, 844, 28, 41, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13647, 528, 112, 3, 45, "Subsection",
 Evaluatable->False],
Cell[13762, 533, 994, 36, 204, "Input"],
Cell[14759, 571, 303, 8, 35, "Input"],
Cell[15065, 581, 148, 4, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15250, 590, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[15365, 595, 1232, 42, 161, "Input"],
Cell[16600, 639, 334, 10, 46, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16983, 655, 127, 2, 65, "Section"],
Cell[CellGroupData[{
Cell[17135, 661, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[17250, 666, 1821, 57, 183, "Input"],
Cell[19074, 725, 333, 10, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19444, 740, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[19558, 745, 1178, 40, 161, "Input"],
Cell[20739, 787, 281, 8, 46, "Input"],
Cell[21023, 797, 300, 9, 46, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21360, 811, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[21475, 816, 1127, 38, 140, "Input"],
Cell[22605, 856, 326, 9, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22968, 870, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[23083, 875, 1403, 46, 140, "Input"],
Cell[24489, 923, 307, 9, 46, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24833, 937, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[24948, 942, 2016, 66, 278, "Input"],
Cell[26967, 1010, 268, 7, 35, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
