(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42159,       1614]
NotebookOptionsPosition[     37984,       1463]
NotebookOutlinePosition[     38699,       1489]
CellTagsIndexPosition[     38656,       1486]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Chapter 9", "Title",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[TextData[{
 StyleBox["Boundary-Value Problems for Second-Order ODEs",
  FontSlant->"Italic"],
 " "
}], "Subtitle",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->24,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
 FontFamily->"Times New Roman"],

Cell[TextData[{
 "Suppose you have copied the package ",
 StyleBox["ODE.m ",
  FontWeight->"Bold"],
 "in the directory  c:\\ODE6. To load it, you have to type ",
 StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["Mathematica", 
    StyleBox["\[RegisteredTrademark]",
     FontWeight->"Plain"]], TraditionalForm]]],
 StyleBox[" session",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{3.476785427828125*^9},
 FontFamily->"Times New Roman",
 FontSize->12],

Cell["<<c:\\ODE6\\ODE.m", "Input",
 CellChangeTimes->{3.476769532421875*^9},
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["9.3  The Program NBoundary", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 9.7", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "-", 
     RowBox[{"x", " ", 
      RowBox[{"y", "'"}]}], "+", 
     SuperscriptBox["y", "2"]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1.5", ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "1000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{"NBoundary", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", 
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], ",", "n", ",", "steps", ",", 
   "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "-", 
     RowBox[{"x", " ", 
      RowBox[{"y", "'"}]}], "+", 
     SuperscriptBox["y", "2"]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1.9", ",", "2.5"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "1000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{"NBoundary", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", 
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], ",", "n", ",", "steps", ",", 
   "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.8", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", "y"}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"2", " ", "\[Pi]"}], "]"}], "==", "0"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "1000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{"NBoundary", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", 
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], ",", "n", ",", "steps", ",", 
   "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.9", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", "y"}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"2", " ", "\[Pi]"}], "]"}], "==", "1"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "1000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", 
   RowBox[{"Sin", "[", "x", "]"}]}], ";"}], "\n", 
 RowBox[{"NBoundary", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", 
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], ",", "n", ",", "steps", ",", 
   "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.10", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", 
     RowBox[{"x", " ", 
      SuperscriptBox["y", "2"]}], "-", 
     RowBox[{"100", 
      SuperscriptBox["x", "3"]}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4"}], ",", 
     RowBox[{"-", "3.5"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "1000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{"NBoundary", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", 
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], ",", "n", ",", "steps", ",", 
   "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", 
     RowBox[{"x", " ", 
      SuperscriptBox["y", "2"]}], "-", 
     RowBox[{"100", 
      SuperscriptBox["x", "3"]}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"52", ",", "53"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "1000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{"NBoundary", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", 
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], ",", "n", ",", "steps", ",", 
   "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.11", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"0.01", 
      RowBox[{
       RowBox[{"y", "'"}], "'"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "0.5"}], ")"}], " ", 
      RowBox[{"y", "'"}]}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "5000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{"NBoundary", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", 
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], ",", "n", ",", "steps", ",", 
   "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.12", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", 
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"y", "'"}]}], "+", 
     RowBox[{"Sin", "[", "x", "]"}], "-", 
     RowBox[{
      SuperscriptBox["x", "2"], 
      RowBox[{"Cos", "[", "x", "]"}]}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"2", "\[Pi]"}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         RowBox[{"y", "'"}], "[", 
         RowBox[{"2", "\[Pi]"}], "]"}]}]}], "==", "2"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1.5"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "2000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", 
   RowBox[{"Sin", "[", "x", "]"}]}], ";"}], "\n", 
 RowBox[{"NBoundary", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", 
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], ",", "n", ",", "steps", ",", 
   "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["9.5  The Programs NBoundary1 and NBoundary2", \
"Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Example 9.14 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", 
     RowBox[{"y", "'"}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"2", "\[Pi]"}], "]"}], "==", "0"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "50"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", 
   RowBox[{"Sin", "[", "x", "]"}]}], ";"}], "\n", 
 RowBox[{"NBoundary1", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", "n", ",", "ansol"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.15 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", 
     RowBox[{
      SuperscriptBox["x", "2"], 
      RowBox[{"y", "'"}]}], "+", 
     RowBox[{"Sin", "[", "x", "]"}], "-", 
     RowBox[{
      SuperscriptBox["x", "2"], 
      RowBox[{"Cos", "[", "x", "]"}]}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"2", "\[Pi]"}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         RowBox[{"y", "'"}], "[", 
         RowBox[{"2", "\[Pi]"}], "]"}]}]}], "==", "2"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", 
   RowBox[{"Sin", "[", "x", "]"}]}], ";"}], "\n", 
 RowBox[{"NBoundary1", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", "n", ",", "ansol"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.16 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", 
     RowBox[{"x", " ", 
      RowBox[{"y", "'"}]}], "-", "x", "+", 
     RowBox[{"x", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "+", 
     RowBox[{"Cos", "[", "x", "]"}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"2", "\[Pi]"}], "]"}], "==", 
      RowBox[{"1", "+", 
       RowBox[{"2", "\[Pi]"}]}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "300"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", 
   RowBox[{"x", "+", 
    RowBox[{"Cos", "[", "x", "]"}]}]}], ";"}], "\n", 
 RowBox[{"NBoundary1", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", "n", ",", "ansol"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.17 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"0.01", 
      RowBox[{
       RowBox[{"y", "'"}], "'"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "0.5"}], ")"}], 
      RowBox[{"y", "'"}]}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", 
      RowBox[{"-", "1"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "300"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{"NBoundary1", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", "n", ",", "ansol"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.18 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", 
     RowBox[{"x", " ", 
      SuperscriptBox["y", "2"]}], "-", 
     RowBox[{"100", " ", 
      SuperscriptBox["x", "3"]}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "50"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"s", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "20"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{"NBoundary2", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", "n", ",", "s", ",", 
   "steps", ",", "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.19 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", 
     RowBox[{"y", "'"}], "-", 
     RowBox[{"x", " ", 
      SuperscriptBox["y", "2"]}], "-", 
     RowBox[{"Cos", "[", "x", "]"}], "+", 
     RowBox[{"Sin", "[", "x", "]"}], "+", 
     RowBox[{"x", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"\[Pi]", "/", "2"}], "]"}], "==", "1"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "65"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"s", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "20"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", 
   RowBox[{"Sin", "[", "x", "]"}]}], ";"}], "\n", 
 RowBox[{"NBoundary2", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", "n", ",", "s", ",", 
   "steps", ",", "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.20 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "-", 
     RowBox[{"2", "y", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"y", "'"}], "2"]}], ")"}]}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "50"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"s", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "50"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{"NBoundary2", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", "n", ",", "s", ",", 
   "steps", ",", "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "-", 
     RowBox[{"2", "y", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"y", "'"}], "2"]}], ")"}]}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dymin", ",", " ", "dymax"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.12"}], ",", 
     RowBox[{"-", "1.1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "50"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"s", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "50"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"NBoundary", "[", 
   RowBox[{"eq", ",", " ", "unk", ",", " ", "var", ",", " ", 
    RowBox[{"{", 
     RowBox[{"a", ",", " ", "b"}], "}"}], ",", " ", "data", ",", " ", 
    RowBox[{"{", 
     RowBox[{"dymin", ",", " ", "dymax"}], "}"}], ",", " ", "n", ",", " ", 
    "steps", ",", " ", "ansol"}], "]"}], " "}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 9.21 ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", 
     RowBox[{
      SuperscriptBox["y", "2"], 
      RowBox[{"y", "'"}]}], "+", 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], "+", 
        RowBox[{"Sin", "[", "x", "]"}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"2", "\[Pi]"}], "]"}], "==", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "80"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"s", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "20"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{"Cos", "[", "x", "]"}]}]}], ";"}], "\n", 
 RowBox[{"NBoundary2", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", "n", ",", "s", ",", 
   "steps", ",", "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["9.6  Problems", "Section",
 FontFamily->"Times New Roman"]], "Section",
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell["Exercise 1.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", "10"}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "10", "]"}], "==", "30"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"50", ",", "60"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "2000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{"NBoundary", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", 
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], ",", "n", ",", "steps", ",", 
   "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", 
     RowBox[{"y", "'"}], "-", 
     RowBox[{"x", " ", "y"}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", "2"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "2000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{"NBoundary", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", 
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], ",", "n", ",", "steps", ",", 
   "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3.", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", 
     RowBox[{
      SuperscriptBox["x", "2"], 
      SuperscriptBox[
       RowBox[{"(", " ", 
        RowBox[{"y", "'"}], ")"}], "2"]}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", "0"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "2000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{"NBoundary", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", 
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], ",", "n", ",", "steps", ",", 
   "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", "y"}]}], "==", "0"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "\[Pi]"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"data", "=", 
    RowBox[{"data", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "[", "0", "]"}], "-", 
         RowBox[{
          RowBox[{"y", "'"}], "[", "0", "]"}]}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"y", "[", "\[Pi]", "]"}], "==", "0.5"}]}], "}"}]}]}], ";"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "10"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "2000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{"NBoundary", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", 
   RowBox[{"{", 
    RowBox[{"dymin", ",", "dymax"}], "}"}], ",", "n", ",", "steps", ",", 
   "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", 
     RowBox[{
      SuperscriptBox["x", "2"], 
      SuperscriptBox[
       RowBox[{"y", "'"}], "2"]}], "-", 
     RowBox[{"Sin", "[", 
      RowBox[{"3", "x"}], "]"}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", "0"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "40"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"s", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"steps", "=", "20"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{"NBoundary2", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", "n", ",", "s", ",", 
   "steps", ",", "ansol"}], "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 6. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", 
     RowBox[{
      SuperscriptBox["x", "2"], "y"}], "-", 
     RowBox[{"Sin", "[", 
      RowBox[{"3", " ", "x"}], "]"}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "2", "]"}], "==", "0"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{"NBoundary1", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", "n", ",", "ansol"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 7. ", "Subsection",
 Evaluatable->False,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "'"}], "+", 
     RowBox[{"y", "'"}], "-", 
     RowBox[{"x", " ", "y"}]}], "==", "0"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"unk", "=", "y"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"var", "=", "x"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "==", "0"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", "100"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ansol", "=", "0"}], ";"}], "\n", 
 RowBox[{"NBoundary1", "[", 
  RowBox[{"eq", ",", "unk", ",", "var", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "data", ",", "n", ",", "ansol"}], 
  "]"}]}], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->"RulerBar",
CellGrouping->Automatic,
WindowSize->{1051, 809},
WindowMargins->{{1, Automatic}, {Automatic, 5}},
DockedCells->FEPrivate`FrontEndResource[
 "FEExpressions", "CompatibilityToolbar"],
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 28, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 128, 4, 102, "Title",
 Evaluatable->False],
Cell[721, 29, 257, 10, 62, "Subtitle",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[1003, 43, 61, 1, 87, "Section"],
Cell[1067, 46, 543, 17, 36, "Text"],
Cell[1613, 65, 148, 4, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1798, 74, 140, 2, 87, "Section"],
Cell[CellGroupData[{
Cell[1963, 80, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[2077, 85, 1360, 48, 236, "Input"],
Cell[3440, 135, 1362, 48, 236, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4839, 188, 111, 3, 45, "Subsection",
 Evaluatable->False],
Cell[4953, 193, 1359, 49, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6349, 247, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[6463, 252, 1390, 50, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7890, 307, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[8005, 312, 1432, 51, 224, "Input"],
Cell[9440, 365, 1390, 49, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10867, 419, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[10982, 424, 1447, 52, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12466, 481, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[12581, 486, 1739, 62, 224, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14369, 554, 159, 3, 65, "Section"],
Cell[CellGroupData[{
Cell[14553, 561, 113, 3, 57, "Subsection",
 Evaluatable->False],
Cell[14669, 566, 1081, 39, 182, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15787, 610, 113, 3, 57, "Subsection",
 Evaluatable->False],
Cell[15903, 615, 1416, 51, 182, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17356, 671, 113, 3, 57, "Subsection",
 Evaluatable->False],
Cell[17472, 676, 1311, 46, 182, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18820, 727, 113, 3, 57, "Subsection",
 Evaluatable->False],
Cell[18936, 732, 1126, 41, 182, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20099, 778, 113, 3, 57, "Subsection",
 Evaluatable->False],
Cell[20215, 783, 1229, 43, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21481, 831, 113, 3, 57, "Subsection",
 Evaluatable->False],
Cell[21597, 836, 1475, 51, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23109, 892, 113, 3, 57, "Subsection",
 Evaluatable->False],
Cell[23225, 897, 1245, 44, 224, "Input"],
Cell[24473, 943, 1584, 55, 245, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26094, 1003, 113, 3, 57, "Subsection",
 Evaluatable->False],
Cell[26210, 1008, 1546, 54, 224, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27805, 1068, 127, 2, 65, "Section"],
Cell[CellGroupData[{
Cell[27957, 1074, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[28071, 1079, 1279, 45, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29387, 1129, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[29501, 1134, 1330, 47, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30868, 1186, 111, 3, 57, "Subsection",
 Evaluatable->False],
Cell[30982, 1191, 1428, 51, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32447, 1247, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[32562, 1252, 1520, 55, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34119, 1312, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[34234, 1317, 1274, 45, 224, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[35545, 1367, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[35660, 1372, 1097, 39, 182, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36794, 1416, 112, 3, 57, "Subsection",
 Evaluatable->False],
Cell[36909, 1421, 1035, 37, 182, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
