(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47169,       1783]
NotebookOptionsPosition[     37768,       1441]
NotebookOutlinePosition[     38522,       1469]
CellTagsIndexPosition[     38479,       1466]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["The Package ODE.m ", "Title",
 Evaluatable->False,
 TextAlignment->Center,
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->36,
 FontSlant->"Italic"],

Cell[CellGroupData[{

Cell["Load ODE.m", "Section",
 FontFamily->"Times New Roman"],

Cell[TextData[{
 "Suppose you have copied the package ",
 StyleBox["ODE.m ",
  FontWeight->"Bold"],
 "in the directory  c:\\ODE6. To load it, you have to type ",
 StyleBox["(\[ShiftKey] + \[ReturnIndicator])  in the current ",
  FontWeight->"Plain"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["Mathematica", 
    StyleBox["\[RegisteredTrademark]",
     FontWeight->"Plain"]], TraditionalForm]]],
 StyleBox[" session",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{{3.476330641953125*^9, 3.476330647875*^9}},
 FontFamily->"Times New Roman",
 FontSize->12],

Cell["<<c:\\ODE6\\ODE.m", "Input",
 CellChangeTimes->{3.4763306520625*^9},
 AspectRatioFixed->True,
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Sysn",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program Sysn", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program evalutes and represents the numerical \
solutions of a system of ordinary differential equations corresponding to a \
fixed set of initial data and shows their plots as well as the phase portrait \
of an arbitrary pair of unknowns.\n\nFor more information about the program \
Sysn type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageSysn", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program Sysn", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n Sysn[sys, unk, var, data, \
T1, index, steps]\n\nFor more information about the program Sysn type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpSysn", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Phase2D",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program Phase2D", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] ",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["The program draws the phase portrait of a planar autonomous \
differential system in Cartesian coordinates.", "Text",
  FontSize->12,
  FontWeight->"Plain"],
 StyleBox["\n\nFor more information about the program Phase2D type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsagePhase2D", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program Phase2D", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox[" \[FilledDiamond]  The command raw is\n Phase2D[sys, unk, unk0, h, \
n, {T1, T2}, steps, unkvar, graph]\n\nFor more information about the program \
Phase2D type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpPhase2D", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["PolarPhase",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program PolarPhase", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program draws the phase portrait of a planar \
autonomous differential system in polar coordinates.\n\nFor more information \
about the program PolarPhase type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsagePolarPhase", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program PolarPhase", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox[" \[FilledDiamond]  The command raw is\n PolarPhase[sys, unk, unk0, \
h, n, {T1, T2}, steps, unkvar, graph]\n\nFor more information about the \
program PolarPhase type ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpPolarPhase", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Phase3D",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program Phase3D", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program draws the phase portrait of a 3D \
autonomous differential system in Cartesian coordinates.\n\nFor more \
information about the program Phase3D type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsagePhase3D", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program Phase3D", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox[" \[FilledDiamond]  The command raw is\n Phase3D[sys, unk, unk0, h, \
n, {T1, T2}, {\[Tau]1, \[Tau]2} steps, unkvar]\n\nFor further information \
about the program Phase3D type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpPhase3D", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["LinSys",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program ", "Section",
  FontFamily->"Times New Roman"],
 "LinSys",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program supplies the general analytical \
solution of a linear differential system with constant coefficients.\n\nFor \
more information about the program LinSys type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageLinSys", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program ", "Section",
  FontFamily->"Times New Roman"],
 "LinSys",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n LinSys[A, b, unk, unk0]\n\n\
For more information about the program LinSys type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpLinSys", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["SerSol",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program ", "Section",
  FontFamily->"Times New Roman"],
 "SerSol",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program gives the approximate solution of a \
Cauchy problem by a power expansion up to a fixed order.\n\nFor more \
information about the program SerSol type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageSerSol", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program ", "Section",
  FontFamily->"Times New Roman"],
 "SerSol",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n SerSol[sys, unk, var, \
unk0, r, T1, T2, steps]\n\nFor more information about the program SerSol type \
in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpSerSol", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Frobenius",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program ", "Section",
  FontFamily->"Times New Roman"],
 "Frobenius",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program supplies the solution of a linear \
second order differential equation at the regular singular origin as \
Frobenius series  up to a fixed order.\n\nFor more information about the \
program Frobenius type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageFrobenius", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program ", "Section",
  FontFamily->"Times New Roman"],
 "Frobenius",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n Frobenius[eq, unk, var, \
order, data1, data2, steps]\n\nFor more information about the program \
Frobenius type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpFrobenius", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Poincare",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program ", "Section",
  FontFamily->"Times New Roman"],
 "Poincare",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program gives the solution of a differential \
system containing a small parameter \[Mu] as a power series of \[Mu].\n\nFor \
more information about the program Poincare type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsagePoincare", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program ", "Section",
  FontFamily->"Times New Roman"],
 "Poincare",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n Poincare[sys, unk, var, \
unk0, par, m, r, T1, T2, steps, pref]\n\nFor more information about the \
program Poincare type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpPoincare", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Liapunov",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program ", "Section",
  FontFamily->"Times New Roman"],
 "Liapunov",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program determines a polynomial function V \
for a given system of a planar differential system and evaluates the regions \
around the origin in which V is positive and its derivative is negative.\n\n\
For more information about the program Liapunov type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageLiapunov", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program ", "Section",
  FontFamily->"Times New Roman"],
 "Liapunov",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n Liapunov[sys, unk, W, m, \
viewx, viewy, valV, valV1, options]\n\nFor more information about the program \
Liapunov type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpLiapunov", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["LStability",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program ", "Section",
  FontFamily->"Times New Roman"],
 "LStability",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program verifies the equilibrium stability by \
the eigenvalues of the Jacobian matrix of the right-hand side of the system \
at the equilibrium points.\n\nFor more information about the program \
LStability type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageLStability", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program ", "Section",
  FontFamily->"Times New Roman"],
 "LStability",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n LStability[sys, unk, xe]\n\
\nFor more information about the program LStability type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpLStability", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["CriticalEqN",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program ", "Section",
  FontFamily->"Times New Roman"],
 "CriticalEqN",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program evaluates the origin stability of a \
planar system with numerical coefficients in the critical case corresponding \
to eigenvalues \[PlusMinus]i\[Beta] , \[Beta]>0 of the Jacobian matrix at the \
origin by Poincar\[EAcute]s method. The program is applicable also when the \
system is not in the canonical form.\n\nFor more information about the \
program CriticaleqN type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageCriticalEqN", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program ", "Section",
  FontFamily->"Times New Roman"],
 "CriticalEqN",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n CriticalEqN[sys, unk]\n\n\
For more information about the program CriticalEqN type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpCriticalEqN", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["CriticalEqS",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program CriticalEqS", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program evaluates the origin stability of a \
planar system with symbolic coefficients in the critical case corresponding \
to eigenvalues \[PlusMinus]i\[Beta] , \[Beta]>0 of the Jacobian matrix at the \
origin by Poincar\[EAcute]s method. The system has to be in the canonical \
form.\n\nFor more information about the program CriticalEqS type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageCriticalEqS", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program CriticalEqS", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n CriticalEqS[sys, unk, \
order]\n\nFor more information about the program CriticalEqS type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpCriticalEqS", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["CManifold",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program CManifold", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program studies the stability properties of \
an equilibrium position by the center manifold method.\n\nFor more \
information about the program CManifold type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageCManifold", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program CManifold", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n CManifold[sys, unk, r]\n\n\
For more information about the program CManifold type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpCManifold", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Bif1",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program Bif1", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program analyzes the origin equilibrium \
properties of a first-order differential equation on varying a parameter.\n\n\
For more information about the program Bif1 type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageBif1", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program Bif1", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n Bif1[eq, unk, par]\n\nFor \
more information about the program Bif1 type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpBif1", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Bif1G",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program Bif1G", "Section",
  FontFamily->"Times New Roman"],
 " ",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program supplies a graphical analysis of the \
equilibrium positions and their properties in a differential equation \
containing one parameter.\n\nFor more information about the program BifG type \
in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageBif1G", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program ", "Section",
  FontFamily->"Times New Roman"],
 "Bif1G",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n Bif1G[eq, unk, par, a, b, \
points]\n\nFor more information about the program Bif1G type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpBif1G", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Bif2",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program Bif2", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program analyzes the origin equilibrium \
properties of a first-order differential equation on varying two parameters.\n\
\nFor more information about the program Bif2 type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageBif2", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program Bif2", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n Bif2[eq, unk, par]\n\nFor \
more information about the program Bif2 type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpBif2", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Bif2G",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program Bif2G ", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program supplies a graphical analysis of the \
equilibrium positions and their properties in a differential equation \
containing two parameters. \n\nFor more information about the program Bif2G \
type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageBif2G", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program Bif2G", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n Bif2G[eq, unk, par, a, b, \
points, valpar]\n\nFor more information about the program Bif2G type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpBif2G", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["HopfBif",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program HopfBif", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program analyzes the Hopf's bifurcation of \
the origin in a planar system with numeric coefficients.\n\nFor more \
information about the program HopfBif type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageHopfBif", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program HopfBif", "Section",
  FontFamily->"Times New Roman"],
 "  ",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n HopfBif[sys, unk, par, \
valpar, {h, n}, {k, m}, {T1, T2}, steps ]\n\nFor more information about the \
program HopfBif type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpHopfBif", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["LindPoinc",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program LindPoinc", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program finds the periodic orbits of a planar \
autonomous system containing a parameter.\n\nFor more information about the \
program LindPoinc type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageLindPoinc", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program ", "Section",
  FontFamily->"Times New Roman"],
 "LindPoinc",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n LindPoinc[sys, unk, var, \
par, m]\n\nFor more information about the program LindPoinc type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpLindPoinc", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["GLindPoinc",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program G", "Section",
  FontFamily->"Times New Roman"],
 "LindPoinc",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program compares the approximate orbits \
derived by LindPoinc with the numerical ones. \n\nFor more information about \
the program GLindPoinc type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageGLindPoinc", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program G", "Section",
  FontFamily->"Times New Roman"],
 "LindPoinc",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n GLindPoinc[sys, unk, var, \
par, r, x0, {T1,T2}]\n\nFor more information about the program GLindPoinc \
type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpGLindPoinc", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NBoundary",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program ", "Section",
  FontFamily->"Times New Roman"],
 "NBoundary",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program solves by shooting method a mixed \
boundary value problem for any second order differential equation.\n\nFor \
more information about the program NBoundary type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageNBoundary", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program ", "Section",
  FontFamily->"Times New Roman"],
 "NBoundary",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n NBoundary[eq, unk, var, \
{a, b}, data, {dymin, dymax}, n, steps, ansol]\n\nFor more information about \
the program NBoundary type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpNBoundary", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NBoundary1",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program ", "Section",
  FontFamily->"Times New Roman"],
 "NBoundary1",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program solves by the finite difference \
method a mixed boundary value problem for any linear second order \
differential equation.\n\nFor more information about the program NBoundary1 \
type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageNBoundary1", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program ", "Section",
  FontFamily->"Times New Roman"],
 "NBoundary1",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n NBoundary1[eq, unk, var, \
{a, b}, data, n, ansol]\n\nFor more information about the program NBoundary1 \
type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpNBoundary1", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NBoundary2",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program ", "Section",
  FontFamily->"Times New Roman"],
 "NBoundary2",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program solves by the finite difference \
method a mixed boundary value problem for any nonlinear second order \
differential equation.\n\nFor more information about the program Nboundary2  \
type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageNBoundary2", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program ", "Section",
  FontFamily->"Times New Roman"],
 "NBoundary2",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n NBoundary[eq, unk, var, \
{a, b}, data, n, s, steps, ansol]\n\nFor more information about the program \
NBoundary2 type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpNBoundary2", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Poinsot",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program Poinsot", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program gives the free motions of a solid \
with a fixed point.\n\nFor more information about the program Poinsot type in \
",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsagePoinsot", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program Poinsot", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n Poinsot[A, B, C0, r0, \
\[Theta]0, b, \[Alpha], steps]\n\nFor more information about the program \
Poinsot type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpPoinsot", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Solid",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program Solid", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program gives the motions of a solid with a \
fixed point.\n\nFor more information about the program Solid type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageSolid", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program Solid", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n Solid[A, B, C0, {\[Psi], \
\[CurlyPhi], \[Theta], t}, z, F, p0, q0, r0, \[Psi]0, \[CurlyPhi]0, \
\[Theta]0, T, steps]\n\nFor more information about the program Solid type in",
  
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpSolid", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NormalForm",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program ", "Section",
  FontFamily->"Times New Roman"],
 "NormalForm",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program reduces a planar system to the normal \
form.\n\nFor more information about the program NormalForm type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageNormalForm", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program ", "Section",
  FontFamily->"Times New Roman"],
 "NormalForm",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n NormalForm[sys, unk]\n\n\
For more information about the program NormalForm type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpNormalForm", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Zeros",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program ", "Section",
  FontFamily->"Times New Roman"],
 "Zeros",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program searches for the zeros of a system of \
two or three finite equations.\n\nFor more information about the program \
Zeros type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageZeros", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program ", "Section",
  FontFamily->"Times New Roman"],
 "Zeros",
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n Zeros[sys, unk, int, n, \
tol]\n\nFor more information about the program Zeros type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpZeros", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Taylor",
 FontWeight->"Bold"]], "Subtitle",
 TextAlignment->Center,
 FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["The Aim of the Program Taylor", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond] The program gives the Taylor expansion of a \
function depending on one or more variables.\n\nFor more information about \
the program Taylor type in ",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"UsageTaylor", "[", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["How to Use the Program Taylor", "Section",
  FontFamily->"Times New Roman"],
 StyleBox["\n", "Section"],
 StyleBox["\[FilledDiamond]  The command raw is \n Taylor[f, var, var0, r]\n\n\
For more information about the program Taylor type in",
  FontSize->12,
  FontWeight->"Plain"]
}], "Section",
 FontFamily->"Times New Roman"],

Cell[BoxData[
 RowBox[{"HelpTaylor", "[", " ", "]"}]], "Input",
 FontFamily->"Times New Roman",
 FontSize->12]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{1267, 814},
WindowMargins->{{12, Automatic}, {Automatic, 6}},
DockedCells->FEPrivate`FrontEndResource[
 "FEExpressions", "CompatibilityToolbar"],
PrintingCopies->1,
PrintingPageRange->{1, 1},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding",
Magnification->1.25,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 28, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 174, 6, 102, "Title",
 Evaluatable->False],
Cell[CellGroupData[{
Cell[789, 33, 61, 1, 87, "Section"],
Cell[853, 36, 564, 17, 36, "Text"],
Cell[1420, 55, 146, 4, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1603, 64, 121, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[1749, 71, 547, 12, 165, "Section"],
Cell[2299, 85, 104, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2440, 93, 369, 9, 165, "Section"],
Cell[2812, 104, 108, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[2969, 113, 124, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[3118, 120, 531, 15, 147, "Section"],
Cell[3652, 137, 107, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3796, 145, 396, 10, 165, "Section"],
Cell[4195, 157, 111, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4355, 166, 127, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[4507, 173, 418, 10, 146, "Section"],
Cell[4928, 185, 110, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5075, 193, 402, 10, 165, "Section"],
Cell[5480, 205, 114, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5643, 214, 124, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[5792, 221, 413, 10, 146, "Section"],
Cell[6208, 233, 107, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6352, 241, 410, 10, 165, "Section"],
Cell[6765, 253, 111, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6925, 262, 123, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[7073, 269, 427, 11, 146, "Section"],
Cell[7503, 282, 106, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7646, 290, 358, 10, 165, "Section"],
Cell[8007, 302, 110, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8166, 311, 123, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[8314, 318, 419, 11, 146, "Section"],
Cell[8736, 331, 106, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8879, 339, 382, 11, 165, "Section"],
Cell[9264, 352, 110, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9423, 361, 126, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[9574, 368, 476, 12, 146, "Section"],
Cell[10053, 382, 109, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10199, 390, 394, 11, 165, "Section"],
Cell[10596, 403, 113, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10758, 412, 125, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[10908, 419, 437, 11, 146, "Section"],
Cell[11348, 432, 108, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11493, 440, 402, 11, 165, "Section"],
Cell[11898, 453, 112, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12059, 462, 125, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[12209, 469, 517, 12, 146, "Section"],
Cell[12729, 483, 108, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12874, 491, 401, 11, 165, "Section"],
Cell[13278, 504, 112, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13439, 513, 127, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[13591, 520, 477, 12, 146, "Section"],
Cell[14071, 534, 110, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14218, 542, 367, 10, 165, "Section"],
Cell[14588, 554, 114, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14751, 563, 128, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[14904, 570, 646, 14, 165, "Section"],
Cell[15553, 586, 111, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15701, 594, 366, 10, 165, "Section"],
Cell[16070, 606, 115, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16234, 615, 128, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[16387, 622, 605, 12, 165, "Section"],
Cell[16995, 636, 111, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17143, 644, 368, 9, 165, "Section"],
Cell[17514, 655, 115, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17678, 664, 126, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[17829, 671, 418, 10, 146, "Section"],
Cell[18250, 683, 109, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18396, 691, 358, 9, 165, "Section"],
Cell[18757, 702, 113, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18919, 711, 121, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[19065, 718, 423, 10, 146, "Section"],
Cell[19491, 730, 104, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19632, 738, 344, 9, 165, "Section"],
Cell[19979, 749, 108, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20136, 758, 122, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[20283, 765, 459, 12, 146, "Section"],
Cell[20745, 779, 105, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20887, 787, 366, 10, 165, "Section"],
Cell[21256, 799, 109, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21414, 808, 121, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[21560, 815, 426, 10, 146, "Section"],
Cell[21989, 827, 104, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22130, 835, 344, 9, 165, "Section"],
Cell[22477, 846, 108, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22634, 855, 122, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[22781, 862, 457, 11, 146, "Section"],
Cell[23241, 875, 105, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23383, 883, 369, 9, 165, "Section"],
Cell[23755, 894, 109, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23913, 903, 124, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[24062, 910, 415, 10, 146, "Section"],
Cell[24480, 922, 107, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24624, 930, 405, 11, 165, "Section"],
Cell[25032, 943, 111, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25192, 952, 126, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[25343, 959, 407, 10, 146, "Section"],
Cell[25753, 971, 109, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25899, 979, 373, 10, 165, "Section"],
Cell[26275, 991, 113, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26437, 1000, 127, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[26589, 1007, 413, 11, 146, "Section"],
Cell[27005, 1020, 110, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27152, 1028, 391, 11, 165, "Section"],
Cell[27546, 1041, 114, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27709, 1050, 126, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[27860, 1057, 433, 11, 146, "Section"],
Cell[28296, 1070, 109, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28442, 1078, 413, 11, 165, "Section"],
Cell[28858, 1091, 113, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29020, 1100, 127, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[29172, 1107, 457, 12, 146, "Section"],
Cell[29632, 1121, 110, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29779, 1129, 393, 11, 165, "Section"],
Cell[30175, 1142, 114, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30338, 1151, 127, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[30490, 1158, 461, 12, 146, "Section"],
Cell[30954, 1172, 110, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31101, 1180, 402, 11, 165, "Section"],
Cell[31506, 1193, 114, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31669, 1202, 124, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[31818, 1209, 377, 10, 146, "Section"],
Cell[32198, 1221, 107, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32342, 1229, 386, 10, 165, "Section"],
Cell[32731, 1241, 111, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32891, 1250, 122, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[33038, 1257, 366, 9, 146, "Section"],
Cell[33407, 1268, 105, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33549, 1276, 446, 11, 165, "Section"],
Cell[33998, 1289, 109, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34156, 1298, 127, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[34308, 1305, 376, 10, 146, "Section"],
Cell[34687, 1317, 110, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34834, 1325, 363, 10, 165, "Section"],
Cell[35200, 1337, 114, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35363, 1346, 122, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[35510, 1353, 393, 11, 146, "Section"],
Cell[35906, 1366, 105, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36048, 1374, 361, 10, 165, "Section"],
Cell[36412, 1386, 109, 3, 35, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36570, 1395, 123, 3, 62, "Subtitle"],
Cell[CellGroupData[{
Cell[36718, 1402, 398, 10, 146, "Section"],
Cell[37119, 1414, 106, 3, 35, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37262, 1422, 353, 9, 165, "Section"],
Cell[37618, 1433, 110, 3, 35, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

