/*
 *	File: lex_general.c
 *
 *      (C) IWTS
 *          KU Nijmegen
 *          The Netherlands
 *
 *      Author: R. Harald Baayen
 *
 *      History:
 *
 *      - mar 1999, version 1.0
 *
 *      Description:
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <math.h>
#include "lex_cons.h"


int leesgetal (s, aantal)
char	*s;
int	*aantal;

{
  int		n;

  n = 0;
  *aantal = 0;

  for (s++; (*s <= '9') && (*s >= '0'); s++) {
    n = 10 * n + *s - '0';
    (*aantal)++;
  }
  return(n);
}


double leesdouble (s, aantal)
char	*s;
int	*aantal;

{
  int		n,
		i, k,
		teken;
  double	a, b, d;

  n = 0;
  k = 0;
  b = NULL_F;
  teken = 1;
  *aantal = 0;

  s++;
  if (*s == '-') {
    teken = -1;
    (*aantal)++;
  }
  else {
    s--;
  }

  for (s++; (*s <= '9') && (*s >= '0'); s++) {
    n = 10 * n + *s - '0';
    (*aantal)++;
  }

  a = (double) n;
  n = 0;

  if (*s == '.') {
    (*aantal)++;

    for (s++; (*s <= '9') && (*s >= '0'); s++) {
      n = 10 * n + *s - '0';
      (*aantal)++;
      k++;
    }

    b = (double) n;

    for (i = 1; i <=k; i++) {
      b = b * 0.1;	
    }
  }

  d = a + b;
  d = d * teken;

  return (d);
}


void change_extension (basename, newname, extension)
char	basename[], newname[], *extension;

{
   strcpy (newname, basename);
   strcat (newname, extension);
}


double power (x, y)
double	x, y;

{
  double	z;

  if (y >= NULL_F) {
    return (pow (x, y));
  }
  else {
    if (x != NULL_F) {
      z = pow (x, (-1.0 * y));
      if (z != NULL_F) {
        z = EINS_F / pow (x, (-1.0 * y));
        return (z);
      }
      else {
        fprintf (stderr, "power () - ERROR\n");
        fprintf (stderr, "x = %f, y = %f, z = %f\n", x, y, z);
        exit (1);
      }
    }
    else{
      return (1.0);
    }
  }
}


void nrerror (error_text)
char	error_text[];

{
  fprintf (stderr, "run time error:\n");
  fprintf (stderr, "%s\n", error_text);
  exit (1);
}


float* vectorF (nl, nh) 
int	nl, nh;

{
  float		*v;

  v = (float *) malloc ((unsigned) (nh - nl + 1) * sizeof (float));

  if (!v) {
    nrerror ("allocation failure in vectorF()\n");
  }

  return (v - nl);
}


int* vectorI (nl, nh)
int	nl,nh;

{
  int		*v;

  v = (int *) malloc ((unsigned) (nh - nl + 1) * sizeof (int));

  if (!v) {
    nrerror ("allocatiob failure in vectorI()\n");
  }

  return (v - nl);
}


double* vector (nl, nh) 
int	nl, nh;

{
  double	*v;

  v = (double *) malloc ((unsigned) (nh - nl + 1) * sizeof (double));

  if (!v) {
    nrerror ("allocation failure in vector()\n");
  }

  return (v - nl);
}


/* matrix() allocates a double matrix with range [nrl..nrh][ncl..nch] */

double** matrix (nrl, nrh, ncl, nch)
int	nrl, nrh, ncl, nch;

{
  double	**m;
  int		i;

  m = (double **) malloc ((unsigned) (nrh - nrl + 1) * sizeof (double *));
  if (!m) {
    nrerror("allocation failure (1) in matrix ()");
  }
  m -= nrl;

  for (i = nrl; i <= nrh; i++) {
    m[i] = (double *) malloc ((unsigned) (nch - ncl + 1) * sizeof (double));
    if (!m[i]) {
      nrerror("allocation failure (2) in matrix ()");
    }
    m[i] -= ncl;
  }

  return (m);
}


/* matrixF() allocates a float matrix with range [nrl..nrh][ncl..nch] */

float** matrixF (nrl, nrh, ncl, nch)
int	nrl, nrh, ncl, nch;

{
  float		**m;
  int		i;

  m = (float **) malloc ((unsigned) (nrh - nrl + 1) * sizeof (float *));
  if (!m) {
    nrerror("allocation failure (1) in matrixF ()");
  }
  m -= nrl;

  for (i = nrl; i <= nrh; i++) {
    m[i] = (float *) malloc ((unsigned) (nch - ncl + 1) * sizeof (float));
    if (!m[i]) {
      nrerror("allocation failure (2) in matrixF ()");
    }
    m[i] -= ncl;
  }

  return (m);
}


void free_vectorF (v, nl, nh) 
float	*v;
int	nl, nh;

{
  free ((char*) (v + nl));
}


void free_vector (v, nl, nh) 
double	*v;
int	nl, nh;

{
  free ((char*) (v + nl));
}


void free_matrixF (m, nrl, nrh, ncl, nch)
float	**m;
int	nrl, nrh, ncl, nch;

{
  int		i;
  for (i = nrh; i >= nrl; i--) {
    free ((char *) (m[i] + ncl));
  }
  free ((char *) (m + nrl));
}


void free_matrix (m, nrl, nrh, ncl, nch)
double	**m;
int	nrl, nrh, ncl, nch;

{
  int		i;
  for (i = nrh; i >= nrl; i--) {
    free ((char *) (m[i] + ncl));
  }
  free ((char *) (m + nrl));
}
