/************************************************************/
/* Program Box-Coxn.sas                                      */
/* Program to compute Box Cox Transformations               */
/* To run this program on your own dataset change           */
/* the name of the file in the file=____ statement          */
/* the number of rows in the n=____ statement and           */
/* the number of columns (variables) in the p=___ statement */
/************************************************************/

options ls=80 pageno=1 formdlim='o' mprint;
%let file=q:\sas-examples\multivariate\norm.dat;
%let n=50;
%let p=1;

 /*macro to expand the string of variables that are processed */
%macro expand(cols);
   %do j=1 %to &cols;
      x&j
   %end;
%mend expand;

 /*macro to perform the Box-Cox transformation on the data matrix */
%macro loop(cols);
   %do i=1 %to &cols;
      proc iml;
         use matrix;
         read all var {x&i};
         in=i(&n);
         allh={-1.0, -0.9, -0.8, -0.7, -0.6, -0.5, -0.4, -0.3, -0.2, -0.1,
           0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1, 1.1, 1.2, 1.3};
         one=j(&n,1,1);
         c=in-(one*(inv(one`*one))*one`);
         do k=1 to 23 by 1;
            h=allh[k,1];
            xh=x&i##h;
            hinv=1/h;
            vhinv=j(&n,1,hinv);
            y=(xh-one)#vhinv;
            my=(one`*y)/&n;
            ycy=y`*c*y;
            lnx=log(x&i);
            slnx=one`*lnx;
            ycyn=ycy/&n;
            if ycyn > 0 then lhp1=-(&n/2)*log(ycyn);
            else lhp1=.;
            lhp2=(h-1)*slnx;
            if ycyn > 0 then lh=lhp1+lhp2;
            else lh=.;
            lhs=lhs//lh;
         end;
         Lambda=allh||lhs;
         print, "Lambda and corresponding likelihood for variables x&i",
           lambda;
         call pgraf(lambda, '*', 'lambda', 'likelihood',
         "plot of lambda vs likelihood for variable x&i");
      quit;
  %end;
%mend loop;

 /*input the data and process the macro */
data matrix;
   infile "&file";
   input (%expand(&p)) (&p*:25.) ;
   title " Box-Cox Transformation plots of &file";
proc print;
%loop(&p)
run;
