/******************************************/
/* Program m10_4_1.sas                    */
/* Confirmatory Factor Analysis           */
/* Performance Assessment Assessment      */
/* Three factor model and                 */
/* Two factor model                       */
/******************************************/

options ls=80 nodate pageno=1 formdlim='o';

title 'CFA Model Performance Assessment Program';

data cmat(type=cov);
     _TYPE_='cov';
    Input _NAME_ $ v1-v8;
    Label v1='suppg'
          v2='suppi'
          v3='asmte'
          v4='asmti'
          v5='fam'
          v6='pap'
          v7='prof1'
          v8='prof2';
    datalines;
v1 0.39600  .       .       .       .       .        .       .
v2 0.24000 0.44100  .       .       .       .        .       .
v3 0.03310 0.04383 0.21400  .       .       .        .       .
v4 0.03983 0.05242 0.12200 0.24400  .       .        .       .
v5 0.09002 0.08361 0.08825 0.08792 0.36000  .        .       .
v6 0.12700 0.15700 0.11300 0.11900 0.20800  0.36500  .       .
v7 0.06587 0.09230 0.09137 0.09284 0.20000  0.19700 0.48000  .
v8 0.10800 0.14000 0.11000 0.06940 0.17500  0.18400 0.19900 0.63400
;

proc calis cov data=cmat method=ml residual=norm edf=264;

   lineqs
       v1=1.000 f1 + e1,
       v2=Lv2f1 f1 + e2,
       v3=1.000 f2 + e3,
       v4=Lv4f2 f2 + e4,
       v5=1.000 f3 + e5,
       v6=Lv6f3 f3 + e6,
       v7=Lv7f3 f3 + e7,
       v8=Lv8f3 f3 + e8;

    std
       e1-e8 = vare1-vare8;

    cov
       f1 f1 = cf1f1,
       f1 f2 = cf1f2,
       f1 f3 = cf1f3,
       f2 f2 = cf2f2,
       f2 f3 = cf2f3,
       f3 f3 = cf3f3;
   var
       v1-v8;
run;
proc calis cov data=cmat method=ml  residual=norm edf=264;

   lineqs
       v1=1.000 f1 + e1,
       v2=Lv2f1 f1 + e2,
       v3=1.000 f2 + e3,
       v4=Lv4f2 f2 + e4,
       v5=Lv5f2 f2 + e5,
       v6=Lv6f3 f2 + e6,
       v7=Lv7f3 f2 + e7,
       v8=Lv8f3 f2 + e8;

    std
       e1-e8 = vare1-vare8;

    cov
       f1 f1 = cf1f1,
       f1 f2 = cf1f2,
       f2 f2 = cf2f2;
   var
       v1-v8;
run;
