/******************************************/
/* Program m10_4_2.sas                    */
/* Confirmatory Factor Analysis           */
/* Performance Assessment Project         */
/* Five factor model                      */
/******************************************/

options ls=80 nodate pageno=1 formdlim='o';

title 'CFA Model Performance Assessment Program';

data cmat(type=cov);
     _TYPE_='cov';
    Input _NAME_ $ v1-v8;
    Label v1='suppg'
          v2='suppi'
          v3='asmte'
          v4='asmti'
          v5='fam'
          v6='pap'
          v7='prof1'
          v8='prof2';
    datalines;
v1 0.39600  .       .       .       .       .        .       .
v2 0.24000 0.44100  .       .       .       .        .       .
v3 0.03310 0.04383 0.21400  .       .       .        .       .
v4 0.03983 0.05242 0.12200 0.24400  .       .        .       .
v5 0.09002 0.08361 0.08825 0.08792 0.36000  .        .       .
v6 0.12700 0.15700 0.11300 0.11900 0.20800  0.36500  .       .
v7 0.06587 0.09230 0.09137 0.09284 0.20000  0.19700 0.48000  .
v8 0.10800 0.14000 0.11000 0.06940 0.17500  0.18400 0.19900 0.63400
;
proc calis cov data=cmat residual=norm modification  edf=264 ;

   lineqs
       v1=1.000 f1 + e1,
       v2=Lv2f1 f1 + e2,
       v3=1.000 f2 + e3,
       v4=Lv4f2 f2 + e4,
       v5=1.000 f3 + e5,
       v6=1.000 f4 + e6,
       v7=1.000 f5 + e7,
       v8=Lv8f5 f5 + e8;

    std
       e1-e4 = vare1-vare4,
       e5= 0,
       e6= 0,
       e7-e8 = vare7-vare8;

    cov
       f1 f1 = cf1f1,
       f1 f2 = cf1f2,
       f1 f3 = cf1f3,
       f1 f4 = cf1f4,
       f1 f5 = cf1f5,
       f2 f2 = cf2f2,
       f2 f3 = cf2f3,
       f2 f4 = cf2f4,
       f2 f5 = cf2f5,
       f3 f3 = cf3f3,
       f3 f4 = cf3f4,
       f3 f5 = cf3f5,
       f4 f4 = cf4f4,
       f4 f5 = cf4f5,
       f5 f5 = cf5f5;
   var
       v1-v8;
run;
