/*****************************************/
/* Program m10_6_1.sas                   */
/* Path Analysis Example                 */
/* Lincoln Strike SEM                    */
/* Fox(1984, p.267) and Lincoln (1979)   */
/*****************************************/

options ls=80 nodate pageno=1 formdlim='o';

title 'Path Analysis SEM with Lincoln Data';

data cmat(type=cov);
     Input _TYPE_ $ _NAME_ $ v1 - v7;
     Label v1='ucon'
           v2='empcon'
           v3='size'
           v4='uniz'
           v5='strikes'
           v6='strikers'
           v7='mandays';
datalines;
n     .    78         78        78       78      78        78       78
cov v1  .007744  .         .        .        .         .        .
cov v2  .000635  .000400   .        .        .         .        .
cov v3  .052401  .005077  1.065024  .        .         .        .
cov v4  .006624  .001471   .066069  .037636  .         .        .
cov v5  .054564  .012024   .823108  .137249 1.809025   .        .
cov v6  .084675  .015990  1.131609  .171995 2.025220  2.496400  .
cov v7  .103616  .019572  1.325756  .184820 1.969703  2.567911 2.989441
;
title2 ' Model with all elements of Gamma';
proc calis covariance residual=norm modification;

     Lineqs

         v1= pv1v4 v4 + pv1v2 v2 + pv1v5 v5 + pv1v6 v6 + pv1v7 v7 + e1,
         v2= pv2v4 v4 + pv2v5 v5 + pv2v6 v6 + pv2v3 v3 + pv2v7 v7 + e2,
         v3= pv3v4 v4 + pv3v5 v5 + pv3v6 v6 + pv3v7 v7 + e3;

     Std
         e1=vare1,
         e2=vare2,
         e3=vare3,
         v4=varv4,
         v5=varv5,
         v6=varv6,
         v7=varv7;

      cov
         v4 v5 = cv4v5,
         v4 v6 = cv4v6,
         v4 v7 = cv4v7,
         v5 v6 = cv5v6,
         v5 v7 = cv5v7,
         v6 v7 = cv6v7;

      var v1 v2 v3 v4 v5 v6 v7;
run;

title2 'Model with some elements of Gamma set to zero';
proc calis covariance residual=norm modification;

     Lineqs

         v1= pv1v4 v4 + pv1v2 v2 + pv1v5 v5 + pv1v6 v6 + pv1v7 v7 + e1,
         v2= pv2v3 v3 + pv2v7 v7 + e2,
         v3= pv3v7 v7 + e3;

     Std
         e1=vare1,
         e2=vare2,
         e3=vare3,
         v4=varv4,
         v5=varv5,
         v6=varv6,
         v7=varv7;

      cov
         v4 v5 = cv4v5,
         v4 v6 = cv4v6,
         v4 v7 = cv4v7,
         v5 v6 = cv5v6,
         v5 v7 = cv5v7,
         v6 v7 = cv6v7;

      var v1 v2 v3 v4 v5 v6 v7;
run;

title 2 ' Lincolns Reduced Model';
proc calis covariance residual=norm modification;

     Lineqs

         v1= pv1v4 v4 + pv1v2 v2 + pv1v5 v5 + pv1v6 v6 + e1,
         v2= pv2v4 v4 + pv2v5 v5 + pv2v6 v6 + pv2v3 v3 + e2,
         v3= pv3v5 v5 + pv3v6 v6 + pv3v7 v7 + e3;

     Std
         e1=vare1,
         e2=vare2,
         e3=vare3,
         v4=varv4,
         v5=varv5,
         v6=varv6,
         v7=varv7;

      cov
         v4 v5 = cv4v5,
         v4 v6 = cv4v6,
         v4 v7 = cv4v7,
         v5 v6 = cv5v6,
         v5 v7 = cv5v7,
         v6 v7 = cv6v7;

      var v1 v2 v3 v4 v5 v6 v7;
run;
