/*****************************************/
/* Program m10_6_2.sas                   */
/* Path Analysis Example                 */
/* Nonrecursive Model from Bollen        */
/*****************************************/

options ls=80 nodate pageno=1 formdlim='o';

title 'Path Analysis SEM for Socioeconomic Status Model';

data cmat(type=cov);
     Input _TYPE_ $ _NAME_ $ v1 - v5;

     Label v1='perInc'
           v2='perocc'
           v3='ovrall'
           v4='income'
           v5='occptn';
datalines;
n    .   432   432   432    432     432
cov v1  .449  .     .      .       .
cov v2  .166  .410  .      .       .
cov v3  .226  .173  .393   .       .
cov v4  .564  .259  .382  4.831    .
cov v5 2.366 3.840 3.082 13.656 452.711
;

proc calis covariance residual=norm modification;

     Lineqs

         v1= pv1v4 v4 + pv1v2 v2 + e1,
         v2= pv2v1 v1 + pv2v5 v5 + e2,
         v3= pv3v1 v1 + pv3v2 v2 + e3;

     Std
         e1=vare1,
         e2=vare2,
         e3=vare3,
         v4=varv4,
         v5=varv5;

      cov
         v4 v5 = cv4v5,
         e1 e2 = ce1e2,
         e1 e3 = ce1e3,
         e2 e3 = ce2e3;

      var v1 v2 v3 v4 v5;
run;

title1 'Revised Socioeconomic Status Model';
proc calis covariance residual=norm modification;

     Lineqs

         v1= pv1v4 v4 + e1,
         v2= pv2v1 v1 + pv2v5 v5 + e2,
         v3= pv3v1 v1 + pv3v2 v2 + e3;

     Std
         e1=vare1,
         e2=vare2,
         e3=vare3,
         v4=varv4,
         v5=varv5;

      cov
         v4 v5 = cv4v5,
         e1 e2 = ce1e2,
         e1 e3 = ce1e3,
         e2 e3 = ce2e3;

      var v1 v2 v3 v4 v5;
run;
title1 'Revised Socioeconomic Status Model with cov of errors zero';
proc calis covariance residual=norm modification;

     Lineqs

         v1= pv1v4 v4 + e1,
         v2= pv2v1 v1 + pv2v5 v5 + e2,
         v3= pv3v1 v1 + pv3v2 v2 + e3;

     Std
         e1=vare1,
         e2=vare2,
         e3=vare3,
         v4=varv4,
         v5=varv5;

      cov
         v4 v5 = cv4v5;

      var v1 v2 v3 v4 v5;
run;
