/*****************************************/
/* Program m10_8_1.sas                   */
/* Path Analysis with Latent Variables   */
/* Stability of Alienation               */
/*****************************************/

options ls=80 nodate pageno=1 formdlim='o';

title 'Joreskog Model A --- Stability of Alienation';

data cmat(type=cov);
     Input _TYPE_ $ _NAME_ $ v1 - v6;
     Label v1='Anomia67'
           v2='Powles67'
           v3='Anomia71'
           v4='Powles71'
           v5='Educ'
           v6='SEI';
datalines;
cov v1  11.834    .       .       .      .        .
cov v2   6.947   9.364    .       .      .        .
cov v3   6.819   5.091  12.532    .      .        .
cov v4   4.783   5.028   7.495   9.986   .        .
cov v5  -3.839  -3.889  -3.841  -3.625  9.610     .
cov v6 -21.899 -18.831 -21.748 -18.755 35.522  450.288
;

proc calis covariance residual=norm edf=931 modification;

     Lineqs

         v1 = 1.000 f1 + e1,
         v2 = Lv2f1 f1 + e2,
         v3 = 1.000 f2 + e3,
         v4 = Lv4f2 f2 + e4,
         v5 = 1.000 f3 + e5,
         v6 = Lv6f3 f3 + e6,
         f1 = pf1f3 f3 + d1,
         f2 = pf3f2 f3 + pf2f1 f1 + d2;


     Std
         e1-e6 = vare1-vare6,
         d1-d2 = vard1-vard2,
         f3    = varf3;


      var v1 v2 v3 v4 v5 v6;
run;

title 'Joreskog Model B --- Stability of Alienation';


proc calis covariance residual=norm edf=931 modification;

     Lineqs

         v1 = 1.000 f1 + e1,
         v2 = Lv2f1 f1 + e2,
         v3 = 1.000 f2 + e3,
         v4 = Lv4f2 f2 + e4,
         v5 = 1.000 f3 + e5,
         v6 = Lv6f3 f3 + e6,
         f1 = pf1f3 f3 + d1,
         f2 = pf3f2 f3 + pf2f1 f1 + d2;


     Std
         e1-e6 = vare1-vare6,
         d1-d2 = vard1-vard2,
         f3    = varf3;

     Cov
         e1 e3 = ce1e3,
         e2 e4 = ce2e4;

      var v1 v2 v3 v4 v5 v6;
run;

title 'Alternative Model C --- Stability of Alienation';


proc calis covariance residual=norm edf=931 modification;

     Lineqs

         v1 = 1.000 f1 + e1,
         v2 = Lv2f1 f1 + e2,
         v3 = 1.000 f2 + e3,
         v4 = Lv4f2 f2 + e4,
         v5 = 1.000 f3 + e5,
         v6 = Lv6f3 f3 + e6,
         f1 = pf1f3 f3 + d1,
         f2 = pf3f2 f3 + pf2f1 f1 + d2;


     Std
         e1-e6 = vare1-vare6,
         d1-d2 = vard1-vard2,
         f3    = varf3;

     Cov
         e1 e3 = ce1e3;

      var v1 v2 v3 v4 v5 v6;
run;
