/*************************************************/
/* Program m3_10a.sas                            */
/* Univariate   Profile analysis, one group      */
/*************************************************/

options ls=80 nodate formdlim='o' pageno=1;
libname examp 'e:';


*/ Univariate Profile Analysis   */

title 'Univariate Profile Analysis, One Group';

data onegrp;
   set examp.m371a;
   if grp=1;

*/Univariate Randomized Block Design */


title2 ' Randomized Block Univariate Design';
data split;
   set onegrp;
   array t{3} col1-col3;
   subj+1;
   do treat = 1 to 3;
   y=t{treat};
   output;
   end;
   drop col1-col3;
run;
proc print data = split;
run;
title3 'Proc GLM to obtain EMS for uncontrained model';
proc glm data=split;
     class subj treat;
     model y=subj treat;
     means treat;
     random subj/test;
run;
title3 'Proc Mixed to obtain variance components & Tests with C.I.';
proc mixed data=split cl covtest;
      class subj treat;
      model y=treat/ddfm=satterth;
      lsmeans treat/pdiff=all cl adjust=Tukey alpha=.05;
      random subj/solution cl;
run;
