/*****************************************************/
/* Program m3_10b.sas                                 */
/* Univariate profile analysis, two groups           */
/*****************************************************/

options ls=80 nodate formdlim='o' pageno=1;

libname examp 'e:\';

/* Univariate Analysis of Two Group Design   */

title  'Univariate Analysis of Split Plot Design';
title2 'Univariate Tests given Parallelism and Circurlarity';
proc print data=examp.m371a;

data split;
     set examp.m371a;
     array t{3} col1-col3;
     subj+1;
     do treat = 1 to 3;
     y=t{treat};
     output;
     end;
     drop col1 - col3;
run;

title3 'Proc GLM Mixed Model Test and EMS';
proc glm data=split;
     class subj grp treat;
     model y=grp subj(grp) treat treat*grp;
     means grp treat;
     random subj(grp)/test;
run;

title3 'Proc Mixed - Estimate Variance Components';
proc mixed data=split cl covtest;
     class grp treat subj;
     model y=grp treat grp*treat/ddfm=satterth;
     lsmeans grp treat/pdiff=all cl adjust=Tukey alpha=.05;
      random subj(grp);
run;
