/******************************************/
/* Program m3_ll_1.sas                    */
/* Power Calculation for Two Groups       */
/******************************************/

options ls=80 nodate pageno=1;

libname examp 'e:\';



proc iml;

title 'Power Calculation for Two Group Location Example';

   alpha=.05;
   s={307 280,
      280 420};
   print s;
   n=5;
   p=2;
   dfh=p;
   dfe=n-p;
   delta={1, 5}; print delta;
   c=1-alpha;
   gamma=2*n**2*delta`*inv(s)*delta/2*n;  print gamma;

   F_cv=finv(c,dfh,dfe,0); print f_cv;

   power=1-probf(F_cv,dfh,dfe,gamma);

   print 'sample size=' n;

   print power;
quit;
