/* ******************************************************************************** */
/* program m3_7_1.sas                                                               */
/* program to generate 3 datasets each with 2 groups and 3 repeated measures        */
/* dataset a: normal population with equal variance-covariance matrices             */
/* dataset b: normal population with unequal variance-covariance matrices           */
/* dataset c: non-normal data                                                       */
/* ******************************************************************************** */

options ls=80 nodate pageno=1 formdlim='o';
libname exampl 'e:\';

/* ******************************************************************************** */
/* creating data set A                                                              */
/* ******************************************************************************** */

proc iml;
   seed=101999;
   z=normal(repeat(seed,25,3));
   u={6,12,30};
   s={7 2 0,
      2 6 3,
      0 3 5};
   a=root(s);
   uu=repeat(u`,25,1);
   y=(z*a)+uu;
   create gp1a from y;
   append from y;
   close gp1a;
quit;
data grp1a;
   set gp1a;
   grp=1;
run;

proc iml;
   seed=82999;
   z=normal(repeat(seed,25,3));
   u={4,9,20};
   s={7 2 0,
      2 6 3,
      0 3 5};
   a=root(s);
   uu=repeat(u`,25,1);
   y=(z*a)+uu;
   create gp2a from y;
   append from y;
   close gp2a;
quit;
data grp2a;
   set gp2a;
   grp=2;
run;

data exampl.m371a;
   set grp1a grp2a;
run;
title 'Set A: Multivariate Normal Equal Covariance Matrices, p=3';
proc print data=exampl.m371a;
run;


/* ******************************************************************************** */
/* creating data set B                                                              */
/* ******************************************************************************** */

proc iml;
   seed=101999;
   z=normal(repeat(seed,25,3));
   u={6,12,30};
   s={7 2 0,
      2 6 3,
      0 3 5};
   a=root(s);
   uu=repeat(u`,25,1);
   y=(z*a)+uu;
   create gp1b from y;
   append from y;
   close gp1b;
quit;
data grp1b;
   set gp1b;
   grp=1;
run;

proc iml;
   seed=82999;
   z=normal(repeat(seed,25,3));
   u={4,9,20};
   s={21 12  2,
      12 26  4,
       2  4 36};
   a=root(s);
   uu=repeat(u`,25,1);
   y=(z*a)+uu;
   create gp2b from y;
   append from y;
   close gp2b;
quit;
data grp2b;
   set gp2b;
   grp=2;
run;

data exampl.m371b;
   set grp1b grp2b;
run;
Title 'Set B: Multivariate Normal Unequal Covariance Matrices, p=3';
proc print data=exampl.m371b;
run;


/* ******************************************************************************** */
/* creating data set C                                                              */
/* ******************************************************************************** */

proc iml;
   seed=101999;
   z=rancau(repeat(seed,25,3));
   u={6,12,30};
   s={7 2 0,
      2 6 3,
      0 3 5};
   a=root(s);
   uu=repeat(u`,25,1);
   y=(z*a)+uu;
   create gp1c from y;
   append from y;
   close gp1c;
quit;
data grp1c;
   set gp1c;
   grp=1;
run;

proc iml;
   seed=82999;
   z=rancau(repeat(seed,25,3));
   u={4,9,20};
   s={7 2 0,
      2 6 3,
      0 3 5};
   a=root(s);
   uu=repeat(u`,25,1);
   y=(z*a)+uu;
   create gp2c from y;
   append from y;
   close gp2c;
quit;
data grp2c;
   set gp2c;
   grp=2;
run;

data exampl.m371c;
   set grp1c grp2c;
run;
Title 'Set C: Non-normal Data, Equal Covariance Matrices, p=3';
proc print data=exampl.m371c;
run;
