/* ****************************** */
/* Program m3_8_1.sas             */
/* Tests of Covariance Structures */
/* ****************************** */

options ls=80 nodate mprint pageno=1;
title1 'Tests of Covariance Structures';
libname examp 'e:\';

proc iml;
   use examp.m371a;
   read all var {col1 col2 col3} where (grp=1) into y1;
   read all var {col1 col2 col3} where (grp=2) into y2;
   k=2;
   n1=nrow(y1);
   n2=nrow(y2);
   n=n1+n2;
   p=ncol(y1);
   df1=n1-1;
   df2=n2-1;
   s1=(y1`*(i(n1)-(1/n1)*j(n1,n1))*y1)/df1;
   s2=(y2`*(i(n2)-(1/n2)*j(n2,n2))*y2)/df2;
   s=(1/(n-k))*(df1*s1+df2*s2);

/* ************************************************ */
/* Box's M Test of Equality of Covariance Matrices  */
/* ************************************************ */
   w1=(n-k)*(log(det(s)));
   w2=(df1*(log(det(s1))))+(df2*(log(det(s2))));
   w=w1-w2;
   c1=(2*p*p+3*p-1)/(6*(p+1)*(k-1));
   c2=(1/df1)+(1/df2)-(1/(n-k));
   c=c1*c2;
   xb=(1-c)*w;
   v1=(p*(p+1)*(k-1))/2;
   probxb=1-probchi(xb,v1);
   print "Boxs Test of Equality of Covariance Matrices---ChiSquare approximation";
   print "Works well for ni>20, p<6, and k<6", xb v1 probxb;
   rho=1-c;
   co1=(p-1)*(p+2)/(6*k-6);
   co2=(1/(df1*df1))+(1/(df2*df2))-(1/((n-k)*(n-k)));
   co=co1*co2;
   omega=p*(p+1)*(co2*(p-1)*(p+2)-6*(k-1)*(1-rho)**2)/48*rho**2;
   print "Box's Modified p-value";
   print omega;
   p_value=probxb+omega*(1-probchi(xb,v1+4)-probxb);
   print p_value;
   difc=co-(c*c);
   v2=(v1+2)/abs(co-(c*c));
   a=v1/(1-c-(v1/v2));
   b=v2/(1-c+2/v2);
        if difc > 0 then fb=w/a;
   else if difc < 0 then fb=(v2*w)/(f*(b-w));
   probfb=1-probf(fb,v1,v2);
   print "Boxs Test of Equality of Covariance Matrices---F approximation";
   print "Can be used for small ni and p and k greater than 6",fb v2 probfb;

/* ************************************* */
/* Test for a Specific Covariance Matrix */
/* ************************************* */
   eo={6 0 0,
       0 6 0,
       0 0 6};
   wx=(n-k)*((log(det(eo)))-(log(det(s)))+(trace(s*inv(eo)))-p);
   cx=(2*p*p+3*p-1)/(6*(p+1)*(n-k));
   x_sc=(1-cx)*wx;
   dfx_sc=(p*(p+1))/2;
   probxsc=1-probchi(x_sc,dfx_sc);
   print "Test of Specific Covariance Matrix--ChiSquare Approximation",s eo,x_sc dfx_sc probxsc;

/* ************************* */
/* Test of Compound Symmetry */
/* ************************* */
   ssq=(trace(s))/p;
   ssqr=(sum(s)-trace(s))/(p*p-p);
   so=j(p,p,ssqr);
   so[1,1]=ssq;
   so[2,2]=ssq;
   so[3,3]=ssq;
   mx=-(n-k)*log(det(s)/det(so));
   cx=(p*(p+1)*(p+1)*(2*p-3))/(6*(p-1)*(p*p+p-4)*(n-k));
   dfmx=(p*p-p-4)/2;
   chimx=(1-cx)*mx;
   prbchimx=1-probchi(chimx,dfmx);
   print "Test for Compound Symmetry--ChiSquare Approximation",chimx dfmx prbchimx;

/* *************************************/
/* Mauchleys Test of Sphericity        */
/* *************************************/

/* To test for circularity, one must replace s with m`*s*m     */
/* where m`m=Identity matrix of order (p-1) x (p-1) and        */
/* replace p in the equations below by p-1                     */
/* This is accomplished in SAS using the IML function ORPOL    */
/* The changes are included below for the test of circurility  */
/* Due to Mauchley and the LBI test due to Sugiura             */

/* Test of Sphericity where the number k the number of groups  */
/* Over which the estimate of Sigma was calculated             */
/* For one group, k=1 so that n-k=n-1                          */

   lambdas=(det(s))/((trace(s)/p)**p);
   cspher=(2*p*p+p+2)/(6*p);
   wspher=-(n-k-cspher)*log(lambdas);
   dfspher=((p-1)*(p+2))/2;
   prbspher=1-probchi(wspher,dfspher);
   print "Mauchleys Test of Sphericity---ChiSquare Approximation",wspher dfspher prbspher;
   T=p*trace(s**2)/(trace(s)**2);
   Tc=(T-1)*p*(n-k)/2;
   prbspher=1-probchi(Tc,dfspher);
   print "Sugiura Test of Sphericity---ChiSquare Approximation",Tc dfspher prbspher;

/* Test of Circularity due to Mauchley and Sugiura LBI test Criterion */
   o=orpol(1:3);
   m=o[,{2,3}];
   c=m`;s_s=m`*s*m;p_p=p-1;
   lambda=(det(s_s))/((trace(s_s)/p_p)**p_p);
   wcir=(n-k)*log(lambda);
   print 'Mauchleys Criterion='lambda;
   ccir=(2*p_p*p_p+p_p+2)/(6*p_p);
   wcir=-(n-ccir)*log(lambda);
   dfcir=((p_p-1)*(p_p+2))/2;
   prbcir=1-probchi(wcir,dfcir);
   print "Mauchleys Test of Circularity---ChiSquare Approximation",wcir dfcir prbcir;
   T=p_p*trace(s_s**2)/(trace(s_s))**2;
   T_c=(T-1)*p_p*(n-k)/2;
   prbcir=1-probchi(T_c,dfcir);
   print "Sugiura Test of Circularity---ChiSquare Approximation",T_c dfcir prbcir;
/* ****************************************** */
/* Joint Test of Sphericity in k populations  */
/* ****************************************** */
   kpopa=(n-k)*p/2;
   knum=(n-k)*p*(df1*trace(s1**2)+df2*trace(s2**2));
   kden=(df1*trace(s1)+df2*trace(s2))**2;
   W=kpopa*((knum/kden)-1);
   dfkpop=((k*p*(p+1)/2))-1;
   probkpop=1-probchi(w,dfkpop);
   print "Joint Test of Sphericity in k populations---ChiSquare Approximation",
         w dfkpop probkpop;
   o=orpol(1:3);
   m=o[,{2,3}];
   c=m`;
   s_1=m`*s1*m;p_p=p-1;
   s_2=m`*s2*m; kpopa=(n-k)*p_p/2;
   kopa=(n-k)*p_p/2;
   knum=(n-k)*p_p*((df1*traces_1**2)+df2*trace(s_2**2));
   kden=(df1*trace(s_1)+df2*trace(s_2))**2;
   w=kpopa*((knum/kden)-1);
   dfkpop=((k*p_p*(p_p+1)/2))-1;
   probkpop=1-probchi(w,dfkpop);
   print "Joint Test of Circurlarity in k populations---ChiSquare Approximation",
         w dfkpop probkpop;

/* ************************************************ */
/* Test of Independence                             */
/* ************************************************ */

   p1=2;
   p2=1;
   g2=(p**2)-((p1**2)+(p2**2));
   g3=(p**3)-((p1**3)+(p2**3));
   g4=(p**4)-((p1**4)+(p2**4));

   s11=s[{1 2},{1 2}];
   s22=s[3,3];

   indw=det(s)/(det(s11)*det(s22));
   inddf=n-k;
   indf=g2/2;
   indc=(2*g3+3*g2)/(12*indf*inddf);
   indchi=-(1-indc)*inddf*log(indw);
   indprob=1-probchi(indchi,indf);
   print "Test of Independence---ChiSquare Approximation",
          indchi indf indprob;

quit;
