/*****************************************/
/* Program m3_8_7.sas                    */
/* Multivariate Circurlarity             */
/* Example from Timm(1980)               */
/*****************************************/

options ls=80 nodate pageno=1;

libname examp 'e:\';

/* Test for Multivariate Circularity  */

proc iml;

   print 'Test of Multivariate Sphericity Using Chi-Square and Adjusted Chi-
          Square Statistics';

   e={  9.6944  7.3056  -6.7972 -4.4264 -0.6736   3.7255,
        7.3056  8.8889  -4.4583 -3.1915 -3.2396   2.9268,
       -6.7972 -4.4583  18.6156  2.5772  0.8837 -10.1363,
       -4.4264 -3.1915   2.5772  5.3981  1.4259  -1.8546,
       -0.6736 -3.2396   0.8837  1.4259 18.3704   -.7769,
        3.7255  2.9268 -10.1363 -1.8546 -0.7769   6.1274};
   print e;
   n=18;
   p=3;
   t=3;
   k=2;
   u=6;
   q=u/p;
   nu_e=n-k;
   nu_h=1;
   e11=e[1:3,1:3];print e11;
   e22=e[4:6,4:6];print e22;
   dn=(e11+e22)/2;
   b=eigval(dn); print b;
   a=eigval(e); print a;
   b=log(b);
   a=log(a);
   chi_2=n#(q#sum(b)-sum(a));
   df=p#(q-1)#(p#q+p+1)/2;
   pvalue=1-probchi(chi_2,df);
   print chi_2 df pvalue;
   c1=p/(12#q#nu_e#df);
   rho= 1-c1#(2#p##2#(q##4-1)+3#p#(q##3-1)-(q##2-1));
   ro_chi_2=(rho#nu_e/n)#chi_2; print rho;
   c2=1/(2#rho##2);
   c3=((p#q-1)#p#q#(p#q+1)#(p#q+2))/(24#nu_e##2);
   c4=((p-1)#p#(p+1)#(p+2))/(24#q##2#nu_e##2);
   c5=df#(1-rho)##2/2;
   omega=c2#(c3-c4-c5); print omega;
   p1=1-probchi(ro_chi_2,df);
   p2=1-probchi(ro_chi_2,df+4);
   cpvalue=(1-omega)#p1+omega#p2;
   print ro_chi_2 cpvalue;

quit;
