/* ******************************************* */
/* Program m3_9a.sas                           */
/* Test of location, two sample case           */
/* ******************************************* */

options ls=80 nodate formdlim='o' pageno=1;

libname examp 'e:';

title1 'Test of Location: Normal Data with Equal Variance-Covariance Matrices';
proc print data=examp.m371a;
proc glm data=examp.m371a;
   class grp;
   model col1 col2 col3=grp /nouni;
   means grp;
   manova h=grp/printe printh canonical;
run;
title1 'Test of Location: Normal Data with Unequal Variance-Covariance Matrices';
proc glm data=examp.m371b;
   class grp;
   model col1 col2 col3=grp /nouni;
   manova h=grp /printe printh;
run;


title2 'Using the procedure due to Nel and van der Merwe';
proc iml;
   use examp.m371b;
   read all var {col1 col2 col3} where (grp=1) into y1;
   read all var {col1 col2 col3} where (grp=2) into y2;
   k=2;
   n1=nrow(y1);
   n2=nrow(y2);
   n=n1+n2;
   p=ncol(y1);
   df1=n1-1;
   df2=n2-1;
   e1=(y1`*(i(n1)-(1/n1)*j(n1,n1))*y1);print E1;
   e2=(y2`*(i(n2)-(1/n2)*j(n2,n2))*y2);print E2;
   s1=e1/df1;print s1;
   s2=e2/df2;print s2;
   w1=s1#(1/n1);
   w2=s2#(1/n2);
   w=w1+w2;
   y1mean=y1[:,];print y1mean;
   y2mean=y2[:,];print y2mean;
   y=y1mean-y2mean;
   xsquare=y*inv(w)*y`;
   print 'Chi-square statistic' xsquare;
   f1=trace(w**2);
   f2=(trace(w))**2;
   fnum=f1+f2;
   d1=trace(w1**2)+trace(w1)**2;
   d2=trace(w2**2)+trace(w2)**2;
   fdem=d1/df1+d2/df2;
   fhat=fnum/fdem;
   print fhat;
   fval=p*fhat*finv(.95,p,fhat)/(fhat-p-1);
   print 'F-Critical value='fval;
   p_valf=1-probf(fval,p,fhat);
   print 'Nel and van der Merwe p-value='p_valf;
   p_ftest=1-probf(18.4159,3,46);
   print 'Wrong p-value of test assuming equal covariance matrices='p_ftest;
quit;

title1 'Test of Location: Non-Normal Data but equal covariance matrices';
proc glm data=examp.m371c;
   class grp;
   model col1 col2 col3=grp /nouni;
   manova h=grp/printe printh;
run;
title1 'Test of Location: Non-Normal Data using Ranks';
proc rank data=examp.m371c out=ranks;
    var col1 col2 col3;
	ranks rcol1 rcol2 rcol3;
run;
proc print data=ranks;
proc glm data=ranks;
   class grp;
   model rcol1 rcol2 rcol3=grp /nouni;
   manova h=grp/printe printh;
run;