/*************************************************/
/* Program m3_9d.sas                             */
/* Multivariate Profile analysis, one group      */
/*************************************************/

options ls=80 nodate formdlim='o' pageno=1;
libname examp 'e:\';


*/ Multivariate Profile Analysis   */

title 'Multivariate Profile Analysis, One Group';

data onegrp;
   set examp.m371a;
   if grp=1;
run;
proc print data=onegrp;

title2 'Using linear Model with an Intercept Model';
proc glm data=onegrp;
   model col1-col3= /nouni;
   manova h=intercept m=(1 -1  0,
                     0  1 -1) prefix=diff /printe printh canonical;
run;
title2 'Nointercept Full Rank Model with Contrasts';
proc glm data=onegrp;
   class grp;
   model col1-col3=grp/noint nouni;
   means grp;
   contrast 'group' grp 1;
   manova m=(1 -1  0,
             0  1 -1) prefix=diff;
   manova m=(1 -1  0) prefix=var1_2;
   manova m=(0  1 -1) prefix=var2_3;
   manova m=(1  0 -1) prefix=var1_3;
run;
title2 'Repeated Measurements';
   proc glm data=onegrp;
   model col1-col3= /nouni;
   repeated test 3 profile/printe printh;
run;
