/*****************************************************/
/* Program m3_9e.sas                                 */
/* Multivariate profile analysis, two groups         */
/*****************************************************/

options ls=80 nodate formdlim='o' pageno=1;

libname examp 'e:';

/* Multivariate Analysis of Two Group Design   */

title  'Multivariate Analysis Two Group Profile Analysis';
proc print data=examp.m371a;

proc glm data=examp.m371a;
   class grp;
   model col1-col3=grp /intercept nouni;
   means grp;
   manova h = grp /printe printh;           /*Test of equal mean vectors      */
   manova h=_all_  m=(1 -1  0,              /* INTERCEPT is Cond|Parll        */
                    0  1 -1)
         prefix=diff /printe printh;        /* Test of    parallelism       */
   contrast 'diff one' grp 1 -1;
   manova m=(1 -1 0);                       /* Interaction Contrast           */
   contrast 'diff two' grp 1 -1;
   manova m=(0 1 -1);                       /* Interaction Contrast           */
run;

proc glm data=examp.m371a;
   class grp;
   model col1-col3=grp/noint nouni;
   contrast 'Mult Cond' grp 1 0,
                        grp 0 1;
   manova m=(1 -1  0,
             0  1 -1)
   prefix=diff/printe printh;                /*Test of equal cond vectors */
run;

title 'Multivariate Tests Given Parallel Profiles';
proc glm data=examp.m371a;
   class grp;
   model col1-col3=grp / nouni;
   contrast 'Univ gr' grp 1 -1;
   manova m=(.33333 .33333 .33333) prefix=Gr/
     printe printh;                         /*Test of group means given parallelism  */

proc glm data=examp.m371a;
   class grp;
   model col1-col3=grp /nouni;
   repeated cond 3 (1 2 3) profile/printm summary;
   manova h=grp m=(1 -1 0,
                      0 1 -1) prefix=diff; /* Test Parallel Profiles (G X C and Conds */
run;
