/********************************************************/
/* Program m3_9f.sas                                    */
/* Test of Parallelism with Unequal Covariance Matrices */
/********************************************************/

options ls=80 nodate formdlim='o' pageno=1;


data solv;
     infile 'e:tab399.dat';
	 input grp id col1 col2 col3 col4;
run;
title1 'Test of Parallelism with Equal Covariance Matrices';
proc print data=solv;
proc glm data=solv;
   class grp;
   model col1-col4=grp /intercept nouni;
   means grp;
   manova h=_all_  m=(1 -1  0 0,
                      0  1 -1 0, 
                      0 0  1 -1)
         prefix=diff /printe printh;        /* Test of    parallelism       */
 run;
title1 'Test of Parallelism with Unequal Covariance Matrices';
title2 'Using the procedure due to Nel and van der Merwe';
proc iml;
   use solv;
   read all var {col1 col2 col3 col4} where (grp=1) into y1;
   read all var {col1 col2 col3 col4} where (grp=2) into y2;
   p=ncol(y1);
   n1=nrow(y1);
   n2=nrow(y2);
   x1=shape(1,n1,1);
   x2=shape(1,n2,1);
   c={1};
   m={1 0 0, -1 1 0, 0 -1 1, 0 0 -1};
   g=nrow(c);
   q1=ncol(x1);
   q2=ncol(x2);
   v=ncol(m);
   v1=n1-q1;
   v2=n2-q1;
   i1=i(n1);
   i2=i(n2);
   e1=y1`*(i1 - x1*inv(x1`*x1)*x1`)*y1;
   e2=y2`*(i2 - x2*inv(x2`*x2)*x2`)*y2;
   s1=e1/v1;
   s2=e2/v2;
   print e1 e2, s1 s2;
   w1=c*inv(x1`*x1)*c`;
   w2=c*inv(x2`*x2)*c`;
   w=w1+w2; 
   b1hat=inv(x1`*x1)*x1`*y1;
   b2hat=inv(x2`*x2)*x2`*y2;
   print b1hat;
   print b2hat; 
   bhat=b1hat-b2hat; 
   s1e=s1*trace(w1*ginv(w));
   s2e=s2*trace(w2*ginv(w));
   se=(s1e+s2e)/g;
   print se;
   cbm=c*bhat*m; 
   print c bhat m;
   print cbm;
   vec_cbm=colvec(cbm); 
   tsquare=vec_cbm`*ginv(m`*se*m@w)*vec_cbm;
   print 'Hotelling test statistic' tsquare;
   vec_w1 = shape(w1`,p,1);
   vech_w1 = t(remove(vec_w1,v));
   vec_w2 = shape(w2`,p,1);
   vech_w2 = t(remove(vec_w2,v));
   vec_w = shape(w`,p,1);
   vech_w = t(remove(vec_w,v));
   a = m`*se*m;
   v_2=v*v;
   vec_a = colvec(a);
   vech_a = t(remove(vec_a,{4 7 8}));
   print 'vec a = dv * vech a, ' vec_a vech_a;
   dv = {1 0 0 0 0 0, 0 1 0 0 0 0, 0 0 1 0 0 0,
         0 1 0 0 0 0, 0 0 0 1 0 0, 0 0 0 0 1 0,
         0 0 1 0 0 0, 0 0 0 0 1 0, 0 0 0 0 0 1};
   print 'duplication matrix' dv;
   fnum=trace((ginv(dv)@vech_w)*(a@a) * (dv @ vech_w`));
   fden1=trace((ginv(dv)@vech_w1)*(a @ a) * (dv @ vech_w1`))/v1;
   fden2=trace((ginv(dv)@vech_w2)*(a @ a) * (dv @ vech_w2`))/v2;
   fhat=fnum/(fden1+fden2);
   newe=fhat-v+1;
   print fhat; print v; print newe;
   fval=(newe/v) * (tsquare/fhat);
   print 'F-Statistic=' fval;
   p_valf=1-probf(fval,v,newe);
   print 'Nel and van der Merwe p value=' p_valf;
quit;


