/*********************************************/
/* Program m4_11_1.sas                       */
/* Nonorthogonal Two-Way MANOVA              */
/* No Empty Cells                            */
/* Empty Cells - Connected Design            */
/* Empty Cells - Disconnected Design         */
/*********************************************/

options ls = 80 nodate pageno=1 formdlim='o';


data Non2;
Title1 ' Two-Way Nonorthogonal MANOVA Analysis --- No Empty Cells';
   infile 'e:\Non2.dat';
   input a b v1 v2;
run;
proc print data=non2;
/* MANOVA Tests*/
title2 'Nonorthogonal Additive Two-way Manova Design';
/* Given order of effects on model statement               */
/* Univariate Type I SS only applicable for wt. test of a  */
/* To obtain a weighted test of b, must have order b a     */
proc glm data=non2;
     class a b;
     model v1 v2=a b/solution xpx i e e1 e3 ss3 ss1;
     lsmeans a b/pdiff=all cl adjust=tukey alpha=.025;
     manova h=a b/htype=3 printe printh;
         estimate 'a1-a3' a 1 0 -1;
         estimate 'a2-a3' a 0 1 -1;
         estimate 'a1-a2' a 1 -1 0;
         estimate 'b1-b2' b 1 -1;

run;
title2 'Nonorthogonal Manova Design With Interaction';
proc glm data=non2;
     class a b;
     model v1 v2=a b a*b/solution xpx e e1 e3 ss3 ss1;
     manova h=a b a*b/htype=3 printe printh;
         estimate 'a1-a3' a 1 0 -1;
         estimate 'a2-a3' a 0 1 -1;
         estimate 'a1-a2' a 1 -1 0;
         estimate 'b1-b2' b 1 -1;
                 estimate '11-12-31+32'      a*b 1 -1 0  0 -1  1;
                 estimate '21-32-31+32'      a*b 0  0 1 -1 -1  1;
         estimate 'Sum inter '       a*b 1 -1 1 -1 -2  2;
         estimate 'Diff=11-12-21+32' a*b 1 -1 -1 1  0  0;
run;
data Non2EC;
Title1 ' Two-Way Nonorthogonal MANOVA Analysis --Empty Cells (connected)';
   infile 'e:\Non2ec.dat';
   input a b v1 v2;
run;
proc print data=non2EC;
/* MANOVA Tests*/
title2 'Nonorthogonal Additive Two-way Manova Design';
proc glm data=non2ec;
     class a b;
     model v1 v2=a b/solution xpx i e e3 ss3 e4 ss4;
     lsmeans a b/pdiff=all cl adjust=tukey alpha=.025;
     manova h=a b/printe printh;
         estimate 'a1-a3' a 1 0 -1;
         estimate 'a2-a3' a 0 1 -1;
         estimate 'a1-a2' a 1 -1 0;
         estimate 'b1-b2' b 1 -1;

run;
title2 'Nonorthogonal Manova Design With Interaction';
proc glm data=non2ec;
     class a b;
     model v1 v2=a b a*b/solution xpx e e4 e3 ss3 ss4;
     manova h=a b a*b/printe printh;
         estimate 'a1-a3' a 1 0 -1;
         estimate 'a2-a3' a 0 1 -1;
         estimate 'a1-a2' a 1 -1 0;
         estimate 'b1-b2' b 1 -1;
                 estimate '11-12-31+32'      a*b 1 -1 0 -1  1;
run;
data Non2EdC;
Title1 ' Two-Way Nonorthogonal MANOVA Analysis --Empty Cells (Disconnected)';
   infile 'e:\Non2edc.dat';
   input a b v1 v2;
run;
proc print data=non2EdC;
/* MANOVA Tests*/
title2 'Nonorthogonal Additive Two-way Manova Design';
proc glm data=non2edc;
     class a b;
     model v1 v2=a b/solution xpx i e e4 ss4;
     means a b;
     lsmeans a b/pdiff=all cl adjust=tukey alpha=.025;
     manova h=a b/printe printh;
         estimate 'a1-a3' a 1 -1;
         estimate 'b1-b2' b 1 -1;

run;
title2 'Nonorthogonal Manova Design With Interaction';
proc glm data=non2edc;
     class a b;
     model v1 v2=a b a*b/solution xpx e e4 ss4;
     manova h=a b a*b/printe printh;
         estimate 'a1-a3'         a  1 -1;
         estimate '11-12-31+32' a*b 1 -1 -1 1;
run;
title2 'Nonorthogonal Manova Design With Interaction NO INTERCEPT';
proc glm data=non2edc;
     class a b;
     model v1 v2=a*b/noint solution xpx e e4 ss4;
     means a*b;
     manova h=a*b/printe printh;
         estimate 'a1-a3'        a*b  1  1 -1 -1;
         estimate '11-12-31+32' a*b  1 -1 -1  1;
run;
