/*********************************************/
/* Program m4_13_1a.sas                       */
/* Two-Way Nested MANOVA                     */
/* Study by Joseph Raffaele                  */
/*********************************************/

options ls = 80 nodate pageno=1 formdlim='o';

filename multnorm 'e:\multnorm.sas';
%include multnorm;

data twon;
Title1 ' Two-Way Fixed Effect Nested MANOVA Analysis';
   infile 'e:\twon.dat';
   input T $ C $ rate comp;
run;
proc print data=twon;
/* MANOVA Tests*/
title2 'Manova Nested Tests';
proc glm data=twon;
     class T C;
     model Rate Comp=C T(C)/solution e3 ss3;
         lsmeans T(C)/ pdiff=all cl adjust=tukey alpha=.025;
     output out=res p=yhatr yhatc r=resr resc;
     manova h= C T(C)/ printe printh;
         contrast 'Diff T w C1' T(C) 1 -1 0 0 0;
         manova m=(1 0,
                   0 1)/printh;
         contrast 'Diff T w C2' T(C) 0 0 1 0 -1,
                                T(C) 0 0 0 1 -1;
         manova m =(1 0,
                    0 1)/ printh;
         contrast 't1-t2 w c2' T(C) 0 0 1 -1 0;
         contrast 't2-t3 w c2' T(C) 0 0 0 1 -1;
     manova m=(1 0);
     manova m=(0 1);
         estimate 't1-t2 w c2' T(C) 0 0 1 -1 0;
         estimate 't2-t3 w c2' T(C) 0 0 0 1 -1;
run;
/* Evaluation of Normality  */
proc plot data=res;
     plot resr*yhatr;
     plot resc*yhatc;
run;
proc univariate data=res normal plot;
     var resr resc;
	 qqplot /normal (mu=est sigma=est);
run;
%multnorm(data=res,var=resr resc, plot=yes);
quit;
/* Confidence Intervals for Nested MANOVA*/
proc transreg data=twon ss2 short;
     model identity(rate comp)=class(T*C/zero=none);
     output out=new1;
run;
proc print data=new1;
proc iml;
     use new1;
     read all var {TT1CC1 TT1CC2 TT2CC1 TT2CC2 TT3CC2} into x;
     read all var {rate comp} into y;
n=nrow(x);
k=ncol(x);
p=ncol(y);
v=inv(x`*x);
A=v*x`*y;print A;
E=(y`*y-y`*x*A);print e;
S=E/(n-k);
C={ 0 1  0 -1  0,
    0 0  0 1 -1};
H=(C*A)`*inv((C*v*C`))*(C*A);
print H S;
newe=n-k;
newh=2;
new1=max(newh,p);
alpha=.025;
newd=newe-new1+newh;
co_2=newe*(new1/newd)*finv(1-alpha,new1,newd);
co=sqrt(co_2);print co;
c1={0 0 0 1 -1};
m={0 1};
psi=c1*A*m`; print psi;
sdpsi=sqrt((m*s*m`)*(c1*v*c1`));
cLpsi=psi-co*sdpsi;
cUpsi=psi+co*sdpsi;
print ' Simultaneous Confidence Interval for T2 vs T3/w. Contract Classes var C';
print 'contrast' c1;
print 'post m '  m;
print 'Confidence Limits:('cLpsi','cUpsi')';
quit;
Title2 'Manova Mixed Model Nested Design --- Teachers Random';
proc glm data=twon;
     class T C;
     model Rate Comp=C T(C)/ss3;
     random T(C)/Test;
     manova h= C E=T(C);
run;

