/*********************************************/
/* Program m4_13_1b.sas                      */
/* Multivariate Latin Square Design          */
/* Hypothetical Data                         */
/* Concept Learning Task Experiment          */
/*********************************************/

options ls = 80 nodate pageno=1 formdlim='o';

filename multnorm 'e:\multnorm.sas';
%include multnorm;

Title1 ' Latin Square MANOVA Design';
data Latin;
     infile 'e:\Latin.dat';
         input Days Hrs Treat V1 V2;
run;
proc print data=latin;
proc glm data=Latin;
     class Days Hrs Treat;
         model V1 V2 = Days Hrs Treat/solution e3 ss3;
         means Days Hrs Treat;
         lsmeans Treat/pdiff=all cl adjust=tukey alpha=.025;
     output out=res1 p=yhatv1 yhatv2 r=resv1 resv2;
         manova h=Days Hrs Treat/Canonical Printe Printh;
run;
/* Evaluation of Normality for Latin Square */
proc univariate data=res1 normal plot;
     var resv1 resv2;
	 qqplot /normal (mu=est sigma=est);
run;
%multnorm(data=res1,var=resv1 resv2, plot=yes);
quit;
