/*****************************************/
/* Program m4_15_1.sas                   */
/* Data from Timm(1975, page 454)        */
/* Repeated Measures Analysis            */
/* Extended Linear Hypotheses            */
/*****************************************/
options ls=80 ps=60 nodate pageno=1 formdlim='o';
title1 ' Repeated Measurement Analysis';

data timm;
   infile 'e:Timm454.dat';
   input group y1 y2 y3 x1 x2 x3;
proc print data=timm;

run;
filename multnorm 'e:\multnorm.sas';
%include multnorm;

proc glm;
   title2 'Multivariate Tests of Groups and Parallelism Using PROC GLM';
   class group;
   model y1-y3 = group/ intercept nouni;
   means group;
   output out=res p=yhat1 yhat2 yhat3 r=res1 res2 res3;
   manova h = group/ printe printh;  /*test of group diffs for means */
   manova h =_all_ m=(.707107        0 -.707107,
                      -.408258 .816497 -.408248)
      prefix = diff/ printe printh;
/* test for conditions given parallelism and test of parallel profiles */
run;
%multnorm(data=res, var=res1 res2 res3, plot=yes);
quit;
run;
proc univariate data=res normal plot;
     var res1 res2 res3;
run;
proc glm;
title2 'Multivariate Test of Conditions';
   class group;
   model y1-y3= group/noint nouni;
   contrast 'Mult Cond' group 1 0 0,
                        group 0 1 0,
                        group 0 0 1;
   manova m=(1 -1 0,
             0 1 -1 )
      prefix = diff/ printe printh; /* test of condtions as vectors */
run;

proc glm;
   title2 'Test of Groups given Parallelism';
   class group;
   model y1 - y3 = group/ noint nouni;
   contrast 'Univ gr' group 1 0 -1,
                      group 0 1 -1;
   manova m=(.3333 .3333 .3333) prefix=Gr/
   printe printh;  /* test of group means given parallel profiles */
run;

/* Univariate Test given Parallelism and Sphericity */
proc glm;
   title2 'Univariate Tests given Parallelism and Sphericity';
   class group;
   model y1 - y3 = group/ nouni;
   repeated trials 3 (1 2 3) profile/printe summary;
   manova h=group m=(1 -1  0,
                     0  1 -1) prefix = diff / printe printh;
run;
data split;
   array t{7} v1 - v7;
   set timm;
   subj+1;
   do trial= 1 to 3;
   if trial = 1 then y=y1;
   if trial = 2 then y=y2;
   if trial = 3 then y=y3;
   output;
   end;
   drop v1 - v7;
   run;
   proc print data=split;
   proc glm data=split;
   title3 'Proc GLM Mixed Model Test and EMS';
     class subj group trial;
     model y=group subj(group) trial trial*group;
     random subj(group)/test;
run;
title2 'Proc Mixed - Estimate Variance Components';
proc mixed data=split cl;
     class group trial subj;
     model y=group trial trial*group/ddfm=satterth;
     lsmeans group trial/pdiff=all cl adjust=Tukey alpha=.05;
      random subj(group);
run;
/**********************************/
/* Extended Linear Hypotheses     */
/**********************************/

title1 ' Extended Linear Hypotheses';

/* IML procedure for Extended Linear Hypothesis */

title2 'Multivariate Test of Group--Using PROC IML';
proc iml;
   use timm;
   a={x1 x2 x3};
   b={y1 y2 y3};
   read all var a into x;
   read all var b into y;
   beta=inv(x`*x)*x`*y;
   print beta;
   n=nrow(y);
   p=ncol(y);
   k=ncol(x);
   nu_h=2; u=3; nu_e=n-k; s0=min(nu_h,u);
   r=max(nu_h,u); alpha=.05;
   denr=(nu_e-r+nu_h);
   roy_2=(r/denr)*finv(1-alpha,r,denr);
   rvalue=sqrt(roy_2);
   m0=(abs(nu_h-u)-1)/2; n0=(nu_e-u-1)/2;
   num=s0**2*(2*m0+s0+1); dent=2*(s0*n0+1);df=s0*(2*m0+s0+1);
   t0_2=(num/dent)*finv(1-alpha,df,dent);
   tovalue=sqrt(t0_2);
   print s0 m0 n0;
   e=(y`*y-y`*x*beta);
   co={1 -1 0, 0 1 -1};
   ao=i(3);
   eo=ao`*e*ao;
   bo=co*beta*ao;
   wo=co*inv(x`*x)*co`;
   ho=bo`*inv(wo)*bo;
   print,"Overall Error Matrix", eo ,
         "Overall Hypothesis Test Matrix",ho;

   /* c`c=eo where c is upper triangle Cholesky matrix */
   c=root(eo);
   f=inv(c`)*ho*inv(c);
   eig=Eigval(round(f,.0001));
   vec=inv(c)*eigvec(round(f,.0001));
   print,"Eigenvalues & Eigenvectors of Overall Test of Ho (Groups)",
      eig vec;

   /* Extended Linear Hypothesis following Overall Group Test */
   m={1 .5, -.5 .5, -.5 -1};
   g=ao*m*co;
   print, "Extended Linear Hypothesis Test Matrix",m g;
   psi=m*bo;
   psi_hat=trace(psi);
   tr_psi=abs(psi_hat);
   h=m*wo*m`;
   einv=inv(eo);
   c=root(einv);
   f=inv(c`)*h*inv(c);
   xeig=Eigval(round(f,.0001));
   print, "Eigenvalues of Extended Linear Hypothesis", xeig;
   denrt=sum(sqrt(xeig));
   dentr=sqrt(sum(xeig));
   to_2=tr_psi/dentr; print, "Extended To**2 Statistic", to_2;
   print, "Extended To**2 Critical Value", tovalue;
   root=tr_psi/denrt; print, "Extended Largest Root Statistic", root;
   print, "Extended Largest Root Critical Value", rvalue;
   print psi_hat alpha;
   ru=psi_hat+rvalue*denrt;
   rl=psi_hat-rvalue*denrt;
   vu=psi_hat+tovalue*dentr;
   vl=psi_hat-tovalue*dentr;
   print 'Approximate Simultaneous Confidence Intervals';
   print 'Contrast Significant if interval does not contain zero';
   print 'Extended Root interval:  ('rl ',' ru ')';
   print 'Extended Trace interval: ('vl ',' vu ')';

   /* Multiple Extended Linear Hypothesis using To**2  */
   m1={1 0,0 0,0 0}; m2={0 0,1 0,0 0}; m3={0 0,0 1,0 0}; m4={0 0,0 0,0 1};
   print,"Multiple Extended Linear Hypothesis Test Matrices", m1,m2,m3,m4;

   g1=ao*m1*co; g2=ao*m2*co; g3=ao*m3*co; g4=ao*m4*co;
   t1=trace(m1*bo); t2=trace(m2*bo); t3=trace(m3*bo); t4=trace(m4*bo);
   tau=t1//t2//t3//t4;
   t11=trace(m1*wo*m1`*eo); t21=trace(m2*wo*m1`*eo);
   t22=trace(m2*wo*m2`*eo); t31=trace(m3*wo*m1`*eo);
   t32=trace(m3*wo*m2`*eo); t33=trace(m3*wo*m3`*eo);
   t41=trace(m4*wo*m1`*eo); t42=trace(m4*wo*m2`*eo);
   t43=trace(m4*wo*m3`*eo); t44=trace(m4*wo*m4`*eo);
   r1=t11||t21||t31||t41; r2=t21||t22||t32||t42;
   r3=t31||t32||t33||t43; r4=t41||t42||t43||t44;
   t=r1//r2//r3//r4;
   print tau,t;
   to_4=tau`*inv(t)*tau;
   print, "Extended Linear Hypothesis Criterion To**2 Squared", to_4;
   print, "Extended To**2 Critical Value", t0_2;
quit;

/* Multivariate test of Parallelism */

title2 'Multivariate Test of Parallelism--Using PROC IML';
proc iml;
   use timm;
   a={x1 x2 x3};
   b={y1 y2 y3};
   read all var a into x;
   read all var b into y;
   beta=inv(x`*x)*x`*y;
   n=nrow(y);
   p=ncol(y);
   k=ncol(x);
   nu_h=2; u=2; nu_e=n-k; s0=min(nu_h,u); r=max(nu_h,u); alpha=.05;
   denr=(nu_e-r+nu_h);
   roy_2=(r/denr)*finv(1-alpha,r,denr);
   rvalue=sqrt(roy_2);
   m0=(abs(nu_h-u)-1)/2; n0=(nu_e-u-1)/2;
   num=s0**2*(2*m0+s0+1); dent=2*(s0*n0+1); df=s0*(2*m0+s0+1);
   t0_2=(num/dent)*finv(1-alpha,df,dent);
   tovalue=sqrt(t0_2);
   print s0 m0 n0;
   e=(y`*y-y`*x*beta);
   co={1 -1 0, 0 1 -1};
   ao={1 0, -1 1, 0 -1};
   eo=ao`*e*ao;
   bo=co*beta *ao;
   wo=co*inv(x`*x)*co`;
   ho=bo`*inv(wo)*bo;
   c=root(eo);
   f=inv(c`)*ho*inv(c);
   eig=eigval(round(f,.0001));
   vec=inv(c)*eigvec(round(f,.0001));
   print,"Eigenvalues & Eigenvectors of Overall test of Ho (Parallelism)",
      eig vec;

   /* Extended Linear Hypothesis following overall Parallelism test */
   m={0 1,1 0};
   g=ao*m*co;
   print, "Extended Linear Hypothesis Test Matrix", m g;

   psi=m*bo;
   psi_hat=trace(psi);
   tr_psi=abs(psi_hat);
   h=m*wo*m`;
   einv=inv(eo);
   c=root(einv);
   f=inv(c`)*h*inv(c);
   xeig=eigval(round(f,.0001));
   print, "Eigenvalues of Extended Linear Hypothesis", xeig;

   to_2=tr_psi/sqrt(sum(xeig)); print, "Extended To**2 Statistic", to_2;
   print,"Extended To**2 Critical Value", tovalue;
   root=tr_psi/sum(sqrt(xeig)); print, "Extended Largest Root Statistic", root;
   print, "Extended Largest Root Critical Value", rvalue;

   print psi_hat alpha;
   ru=psi_hat+rvalue*sum(sqrt(xeig));
   rl=psi_hat-rvalue*sum(sqrt(xeig));
   vu=psi_hat+tovalue*sqrt(sum(xeig));
   vl=psi_hat-tovalue*sqrt(sum(xeig));
   print 'Approximate Simultaneous Confidence Intervals';
   print 'Contrast Significant if interval does not contain zero';
   print 'Extended Root  Interval: ('rl ',' ru ')';
   print 'Extended Trace Interval: ('vl '.' vu ')';
quit;

/* Multivariate test of Conditions as vectors  */

title2 'Multivariate Test of Conditions--Using PROC IML';
proc iml;
   use timm;
   a={x1 x2 x3};
   b={y1 y2 y3};
   read all var a into x;
   read all var b into y;
   beta=inv(x`*x)*x`*y;
   n=nrow(y);
   p=ncol(y);
   k=ncol(x);
   nu_h=3; u=2; nu_e=n-k; s0=min(nu_h,u); r=max(nu_h,u); alpha=.05;
   denr=(nu_e-r+nu_h);
   roy_2=(r/denr)*finv(1-alpha,r,denr);
   rvalue=sqrt(roy_2);
   m0=(abs(nu_h-u)-1)/2; n0=(nu_e-u-1)/2;
   num=s0**2*(2*m0+s0+1); dent=2*(s0*n0+1); df=s0*(2*m0+s0+1);
   t0_2=(num/dent)*finv(1-alpha,df,dent);
   tovalue=sqrt(t0_2);
   print s0 m0 n0;
   e=(y`*y-y`*x*beta);
   co=i(3);
   ao={1 0, -1 1, 0 -1};
   eo=ao`*e*ao;
   bo=co*beta*ao;
   wo=co*inv(x`*x)*co`;
   ho=bo`*inv(wo)*bo;
   c=root(eo);
   f=inv(c`)*ho*inv(c);
   eig=eigval(round(f,.0001));
   vec=inv(c)*eigvec(round(f,.0001));
   print, "Eigenvalues & Eigenvectors of Overall test of Ho (Conditions)",
      eig vec;

   m={1 0 1, 0 1 1};
   g=ao*m*co;
   print, "Extended Linear Hypothesis Test Matrix", m g;

   psi=m*bo;
   psi_hat=trace(psi);
   tr_psi=abs(psi_hat);
   h=m*wo*m`;
   einv=inv(eo);
   c=root(eo);
   f=inv(c`)*h*inv(c);
   xeig=eigval(round(f,.0001));
   print, "Eigenvalues of Extended Linear Hypothesis", xeig;

   to_2=tr_psi/sqrt(sum(xeig)); print, "Extended To**2 Statistic", to_2;
   print, "Extended T0**2 Critical Value", tovalue;
   root= tr_psi/sum(sqrt(xeig)); print, "Extended Largest Root Statistic",
      root;
   print, "Extended Largest Root Critical Value", rvalue;

   print psi_hat alpha;
   ru=psi_hat+rvalue*sum(sqrt(xeig));
   rl=psi_hat-rvalue*sum(sqrt(xeig));
   vu=psi_hat+tovalue*sqrt(sum(xeig));
   vl=psi_hat-tovalue*sqrt(sum(xeig));
   print 'Approximate Simultaneous Confidence Intervals';
   print 'Contrast Significant if interval does not contain zero';
   print 'Extended Root  Interval: ('rl ',' ru ')';
   print 'Extended Trace Interval: ('vl ',' vu ')';
quit;
title2 'Multivariate Test of Omega_H using Wald Test';
proc iml;
   use timm;
   a={x1 x2 x3};
   b={y1 y2 y3};
   read all var a into x;
   read all var b into y;
   beta=inv(x`*x)*x`*y;
   n=nrow(y);
   p=ncol(y);
   k=ncol(x);
   nu_e=n-k;
   e=(y`*y-y`*x*beta);
   print,"Overall Error Matrix", e ;
   /* Wald test of Extended linear hypothesis */
   c_star={1 0 0 -1 0 0 0 0 0,
           0 1 0 0 -1 0 0 0 0,
           0 0 0 0 1 0 0 -1 0,
           0 0 0 0 0 1 0 0 -1};
   print, "Hypothesis Test Matrix for Wald Test", c_star;
   d=i(3)@x;
   sigma= e/(n-k);
   Omega=sigma@i(n);
   v=inv(c_star*inv((d`*inv(omega)*d))*c_star`);
   b=shape(beta,9,1,0);
   chi_2=(c_star*b)`*v*(c_star*b);
   df=4;
   p_value=1-probchi(chi_2,df);
print 'Wald Statistic for Extended Hypothesis', chi_2 df p_value;
   f=chi_2/4;
   p_value=1-probf(f,df,nu_e);
print 'F Statistic for Extended Hypthesis', f df nu_e p_value;
   quit;
