/********************************************************************/
/* Program 4_17_1.sas                                               */
/* Repeated Measures Design of Edwards                              */
/*                                                                  */
/* The SAS routine power.sas was supplied by Muller, La Vange       */
/* Ramey, and Ramey (1992) as shown in their JASA (1992) article    */
/* "Power calculations for general linear models including repeated */
/* measures applications", pp 1209-1226                             */
/********************************************************************/

options ls=80 nodate pageno=1 formdlim='o';

title ' Power Analysis for Repeated Measures design';
title2 'Anova Main Effect Test';

proc iml symsize=1000;
%include 'e:\power.sas';
alpha = .05;
   C={1 0 -1,
      0 1 -1};
   U={1, 1, 1}/3;
   beta={4 7 10,
         7 8 11,
         5 7  9};
   sigma={74 65 35,
          65 68 38,
          35 38 26};
   essencex=i(3);
   repN={5 10 15};
   round=3;
   run power;
   title2 'Mult Test of Equal Group Mean vectors';
   alpha = .05;
   C={1 0 -1,
      0 1 -1};
   U={1 0 0, 0 1 0, 0 0 1};
   beta={4 7 10,
         7 8 11,
         5 7  9};
   sigma={74 65 35,
          65 68 38,
          35 38 26};
   essencex=i(3);
   repN={5 10 15};
   round=3;
   run power;
   title2 'Test of Conditions given parallelism';
   alpha = .05;
   C={.33333 .33333 .33333};
   U={ .707107  .408248,
      -.707107  .408248,
             0 -.816497};
   beta={4 7 10,
         7 8 11,
         5 7  9};
   sigma={74 65 35,
          65 68 38,
          35 38 26};
   essencex=i(3);
   repN={5 10 15};
   round=3;
   run power;
   title2 'Test of Interaction or Parallelism';
   alpha = .05;
   C={1 -1 0,
      0 1 -1};
   U={ .707107  .408248,
      -.707107  .408248,
             0 -.816497};
   beta={4 7 10,
         7 8 11,
         5 7  9};
   sigma={74 65 35,
          65 68 38,
          35 38 26};
   essencex=i(3);
   repN={5 10 15};
   round=3;
   run power;
   title2 'Mult Test of Equal Condition Vectors';
   alpha = .05;
   C={1 0 0,
      0 1 0,
      0 0 1};
   U={ .707107  .408248,
      -.707107  .408248,
             0 -.816497};
   beta={4 7 10,
         7 8 11,
         5 7  9};
   sigma={74 65 35,
          65 68 38,
          35 38 26};
   essencex=i(3);
   repN={5 10 15};
   round=3;
   run power;
quit;
