/********************************************/
/* Program m4_3_1.sas                       */
/* Multivariate Regression                  */
/* Rohwer data from Timm(1975), pp.281,345  */
/********************************************/

options ls = 80 nodate pageno=1 formdlim='o';
filename multnorm 'e:\multnorm.sas';
%include multnorm;
title1 ' Multivariate Regression';

data rohwer;
   infile 'e:\rohwer.dat';
   input y1-y3 x0-x5;
   label y1='PPVT'
         y2='RPMT'
		 y3='SAT'
		 x0='Gr'
		 x1='N'
         x2='S'
		 x3='NS'
		 x4='NA'
		 x5='SS';
proc print data=rohwer;
run;

/* Calculations for Regression and Multivariate Cooks Distance */
proc iml;
   title2 'Using PROC IML, including Cooks Distance';
   use rohwer;
   v={y1 y2 y3};
   w={x0 x1 x2 x3 x4 x5};
   read all var v into y;
   read all var w into x;
   beta=inv(x`*x)*x`*y;
   print 'Regression Coefficients' beta;
   n=nrow(y);
   p=ncol(y);
   k=ncol(x);
   S=(y`*y-y`*x*beta)/(n-k);
   print 'Estimated Covariance Matrix' S;
   v=inv(k*s)@(x`*x);
   b=shape(beta`,p*k,1);
   m=n-1;
   x1=x[1:m,1:k];
   y1=y[1:m,1:p];
   beta1=inv(x1`*x1)*x1`*y1;
   b1=shape(beta1`,p*k,1);
   d1=(b-b1)`*v*(b-b1);
   wk1=k*d1;
   obs=32;
   index=obs;
   do i=2 to 31;
      j=n-i;
      x2=x[1:j,1:k]; x1=x[j+2:n,1:k];
      x2=x2//x1;
      y2=y[1:j,1:p]; y1=y[j+2:n,1:p];
      y2=y2//y1;
      beta2=inv(x2`*x2)*x2`*y2;
      b2=shape(beta2`,p*k,1);
      d2=(b-b2)`*v*(b-b2);
      d1=d1//d2;
      obs=obs-1;
      index=index//obs;
   end;
   x1=x[2:n,1:k];
   y1=y[2:n,1:p];
   beta1=inv(x1`*x1)*x1`*y1;
   b1=shape (beta1`,p*k,1);
   d2=(b-b1)`*v*(b-b1);
   d1=d1//d2;
   obs=1;
   index=index//obs;
   Influnce=index||d1;
   print 'Obs # //Multivariate Cooks Distance(i)', INFLUNCE;
   max=max(d1); print 'Max Distance' max;
quit;
proc corr;
     var y1 y2 y3 x1 x2 x3 x4 x5;
run;
/* Multivariate Regression using PROC REG */
proc reg data=rohwer;
   title2 'Full Model Analysis';

/* Full Model Analysis */
   model y1-y3 = x1-x5;
   output out=res r=y1resf y2resf y3resf
                  p=y1hatf y2hatf y3hatf;
   plot residual.*predicted.;
   B1:mtest x1,x2,x3,x4,x5/print;  /* Simultaneous test that coefficients equal zero */
   N:mtest x1;                 /* test that x1 equals zero */
   S:mtest x2;                 /* test that x2 equals zero */
   NS:mtest x3;                 /* test that x3 equals zero */
   NA:mtest x4;                  /* test that x4 equals zero */
   SS:mtest x5;                  /* test that x5 equals zero */
   N_SS:mtest x1,x5/print;         /* Partial test equals zero */  
   All:mtest intercept,x1,x3,x4,x5;/* test that int and all coeff are zero */
run;
%multnorm(data=res,
          var=y1resf y2resf y3resf,
                  plot=yes);
run;
proc reg data=rohwer;
   title2 ' Plots Full Model with C(q)';
   model y1-y3 = x1-x5/selection=cp;
   plot cp.*np./chocking=red cmallows=blue;
run;
title2 'Using Stepwise Selection - Full Model';
proc reg data=rohwer;
   model y1-y3=x1-x5/selection=backward;
run;
/* Reduced Model Analysis*/
title2 'Reduced Model';
proc reg data=rohwer;
   model y1-y3 = x2-x4;
   B: mtest intercept,x2,x3,x4/print;  /* Joint Test B=0  */
   B1:mtest x2,x3,x4/print;            /* Joint Test B1=0 */
   S:mtest x2;
   NS:mtest x3;
   NA:mtest x4;
run;
title2 'Reduced Model Stepwise';
proc reg data=rohwer;
   model y1-y3 = x2 -x4/selection=stepwise;
run;
/* print residuals for full model        */
/* write residuals to and external file  */
proc print data=res;
data _null_;
   set res;
   file 'e:res.dat';
   put y1resf y2resf y3resf;
run;
/* Calculation of Multivariate Eta Squared for Full and Reduced Models */
proc iml;
   title2 'Multivariate Eta Squared for Full and Reduced Models';
   n=32;
   g1=6;
   g2=4;
   p=3;
   LmdaF=.24307;
   LmdaR=.33413;
   Full=1-n*LmdaF/(n-g1+LmdaF);
   Reduced=1-n*LmdaR/(n-g2+LmdaR);
   print 'Eta Squared full model' Full, 'Eta Squared reduced model' Reduced;
   use rohwer;
   v={y1 y2 y3};
   w={x0 x2 x3 x4};
   read all var v into y;
   read all var w into x;
   beta=inv(x`*x)*x`*y;
   print 'Regression Coefficients Reduced Model' beta;
   n=nrow(y);
   p=ncol(y);
   k=ncol(x);
   S=(y`*y-y`*x*beta)/(n-k);
   print 'Estimated Covariance Matrix Reduced Model' S;
   eigs=eigval(S);
   print 'Eigenvalues of S' eigs;
   partial=corr(S);
   print 'Matrix of partial correlations' partial;
   eigprtl=eigval(partial);
   print 'Eigenvalues of partial' eigprtl;
   Dets=det(S); 
   print ' Determinant of S' Dets;
   vv=inv(x`*x);
   newe=n-k;
   newh=nrow(beta)-1;;
   new1=max(newh,p);
   ss=min(newh,p);
   mm=(abs(newh-p)-1)/2;
   nn=(newe-p-1)/2;
   BLH1=ss*(2*mm+ss+1);
   BLH2=2*(ss*nn+1);
   BNP1=ss*(2*mm+ss+1);
   BNP2=ss*(2*nn+ss+1);
   alpha=.05;
   newd=newe-new1+newh;
   co_2=newe*(new1/newd)*finv(1-alpha,new1,newd);
   co_R=sqrt(co_2);print 'ROY approx Critical Value' co_R;
   coBLH_2=(newe*(ss*BLH1/BLH2))*finv(1-alpha,BLH1,BLH2);
   co_BLH=sqrt(coBLH_2); print 'BLH approx Critical Value' co_BLH;
   num=(ss*bnp1/bnp2)*finv(1-alpha,bnp1,bnp2);
   den=1+((bnp1/bnp2)*finv(1-alpha,bnp1,bnp2));
   v=num/den;
   coBNP_2=newe*(v/(1-v));
   co_BNP=sqrt(coBNP_2); print 'BNP approx Critical value' co_BNP;
   c={0 0 0 1};
   m={0 0 1};
   beta43=c*beta*m`;
   sd43=sqrt((m*s*m`)*(c*vv*c`));print sd43; print beta43;
   cL43=beta43-co_R*sd43;
   cU43=beta43+co_R*sd43;
   print 'Simultaneous Confidence Interval for Beta 43 ---ROY';
   print ' contrast 'c ;
   print ' post m'   m;
   print 'Confidence Limits:('cL43','cU43')';
quit;
