/********************************************/
/* Program m4_5_1.sas                       */
/* One-Way MANOVA                           */
/* Data from Stanley Jacobs and R Hritz     */
/* Analysis of entire data set              */
/********************************************/

options ls = 80 nodate pageno=1 formdlim='o';

filename multnorm 'e:\multnorm.sas';
%include multnorm;

title1 ' One-Way MANOVA with Outlier';

data Stan;
   infile 'e:\Stan_hz.dat';
   input Treat $ Low High;
proc print data=stan;
run;
proc glm data=stan;
     class treat;
     model low high=Treat/nouni;
     means treat/ hovtest=bf;
     output out=res p=yhatL yhatH r=resL resH;
     manova h=treat;
run;
proc print data=res;
run;
proc gplot data=res;
     plot resL*yhatL;
     plot resH*yhatH;
run;
proc univariate data=res normal;
     var resl resh;
	 qqplot/normal (mu=est sigma=est);
run;
%multnorm(data=res,var=resL resH, plot=yes);
quit;
run;
