/********************************************/
/* Program m4_5_1a.sas                      */
/* One-Way MANOVA                           */
/* Data from Stanley Jacobs and R Hritz     */
/* Analysis of data without outlier         */
/********************************************/

options ls = 80 nodate pageno=1 formdlim='o';

filename multnorm 'e:\multnorm.sas';
%include multnorm;

title1 'One-way MANOVA without Outlier';
data Stan;

   infile 'e:\Stan_hz.dat';
   input Treat $ Low High;
   if _n_ =82 then delete;
run;
proc glm data=stan;
     class treat;
     model low high=Treat;
     means treat/ hovtest=bf;
     lsmeans treat/pdiff=all cl adjust=tukey alpha=.025;
     output out=res p=yhatL yhatH r=resL resH;
     manova h=treat/canonical printe printh;
     contrast '1vs3' treat 1 0 -1;
     contrast '2vs3' treat 0 1 -1;
     contrast '1vs2' treat 1 -1 0;
     manova m=(1 0,
               0 1);
     manova m=(1 0);
     manova m=(0 1);
     manova m=(1 1);
     estimate '1vs3'   treat 1 0 -1;
     estimate '2vs3'   treat 0 1 -1;
     estimate '1vs2'   treat 1 -1 0;
     estimate '12vs3'  treat .5 .5 -1;
     estimate '1vs23'  treat 1 -.5 -.5;
run;
/* Residual Plots*/
proc gplot data=res;
     plot resL*yhatL;
     plot resH*yhatH;
run;
proc univariate data=res normal;
     var resl resh;
	 qqplot /normal (mu=est sigma=est);
run;
%multnorm(data=res,var=resL resH, plot=yes);
quit;

/* Construct Confidence Intervals for Means    */

proc transreg data=stan ss2 short;
     model identity(low high)=class(treat/zero=none);
     output out=new;
run;

proc iml;
     use new;
     read all var {treataa treatc treatnc} into x;
     read all var {low high} into y;
n=nrow(x);
k=ncol(x);
p=ncol(y);
v=inv(x`*x);
B=v*x`*y;print B;
E=(y`*y-y`*x*B);
S=E/(n-k);
C={1 0 -1,
   0 1 -1};
H=(C*B)`*inv((C*v*C`))*(C*B);
print H S;
newe=n-k;
newh=nrow(C);
new1=max(newh,p);
ss=min(newh,p);
mm=(abs(newh-p)-1)/2;
nn=(newe-p-1)/2;
BLH1=ss*(2*mm+ss+1);
BLH2=2*(ss*nn+1);
BNP1=ss*(2*mm+ss+1);
BNP2=ss*(2*nn+ss+1);
alpha=.05;
newd=newe-new1+newh;
co_2=newe*(new1/newd)*finv(1-alpha,new1,newd);
co_R=sqrt(co_2);print 'ROY approx Critical Value' co_R;
coBLH_2=(newe*(ss*BLH1/BLH2))*finv(1-alpha,BLH1,BLH2);
co_BLH=sqrt(coBLH_2); print 'BLH approx Critical Value' co_BLH;
num=(ss*bnp1/bnp2)*finv(1-alpha,bnp1,bnp2);
den=1+((bnp1/bnp2)*finv(1-alpha,bnp1,bnp2));
v=num/den;
coBNP_2=newe*(v/(1-v));
co_BNP=sqrt(coBNP_2); print 'BNP approx Critical value' co_BNP;
c1={1 0 -1};
m={0 1};
psi=c1*B*m`;print 'Contrast' psi;
sdpsi=sqrt((m*s*m`)*(c1*v*c1`));
print 'Standard Error Contrast' sdpsi;
cLpsi=psi-co_BLH*sdpsi;
cUpsi=psi+co_BLH*sdpsi;
print ' Approx Simultaneous Interval for Treatment 1 vs 3 on var High -- BLH';
print 'contrast' c1;
print 'post m '  m;
print 'Confidence Limits:('cLpsi','cUpsi')';
quit;
run;

/* STP Procedure */ 

proc multtest data=stan bon sidak pvals permutation alpha=.05;
     class treat;
     test mean(Low High);
     contrast '1vs3'  1 0 -1;
     contrast '2vs3'  0 1 -1;
     contrast '1vs2'  1 -1 0;
     contrast '12vs3' .5 .5 -1;
     contrast '1vs23' 1 -.5 -.5;
run;
