/*********************************************/
/* Program m4_5_2.sas                        */
/* One-Way MANCOVA                           */
/* Data from Rohwer Low and High SES Groups  */
/*********************************************/

options ls = 80 nodate pageno=1 formdlim='o';

filename multnorm 'e:\multnorm.sas';
%include multnorm;

data Roh2;
Title1 ' One-Way MANCOVA Analysis';
   infile 'e:\Rohwer2.dat';
   input Treat PPVT RPMT SAT N S NS NA SS;
   one1=1;
   one2=1;
   if treat=1 then one2=0;
   if treat=2 then one1=0;
   n1=n; n2=n;
   if treat=1 then n1=n and n2=0;
   if treat=2 then n2=n and n1=0;
   s1=s;s2=s;
   if treat=1 then s1=s and s2=0;
   if treat=2 then s2=s and s1=0;
   ns1=ns;ns2=ns;
   if treat=1 then ns1=ns and ns2=0;
   if treat=2 then ns2=ns and ns1=0;
   na1=na;na2=na;
   if treat=1 then na1=na and na2=0;
   if treat=2 then na2=na and na1=0;
   ss1=ss;ss2=ss;
   if treat=1 then ss1=ss and ss2=0;
   if treat=2 then ss2=ss and ss1=0;
run;
proc print data=Roh2;
/* Test of Parallelism using Proc GLM  */
proc glm data=Roh2;
   title2 'Test of Parallelism using Proc GLM';
   class Treat;
   model PPVT RPMT SAT = Treat N S NS NA SS
                         Treat*N Treat*S Treat*NS Treat*NA Treat*SS/nouni ss3;
   manova h=treat*N treat*S Treat*NS treat*NA Treat*SS;
run;
/* Test of Parallelism */
   title2 'Joint Test of Parallelism using PROC REG';
   proc reg data=Roh2;
   model PPVT RPMT SAT=one1 N1 S1 NS1 NA1 SS1
                       one2 N2 S2 NS2 NA2 SS2/noint;
   Gamma_eq: mtest n1-n2=0,s1-s2=0,ns1-ns2=0,na1-na2=0,ss1-ss2=0/print;
   n: mtest n1-n2;
   s: mtest s1-s2;
   ns:mtest ns1-ns2;
   na:mtest na1-na2;
   ss:mtest ss1-ss2;
run;
/* Test of Covariates one at a time*/
/* Note Proc GLM cannot test that all covaiates are zero */
/* One Must Use Proc REG and MTEST as illustraed  above  */             
title2 'Tests of Covariates using Proc GLM';
proc glm data=Roh2;
     class treat;
     model PPVT RPMT SAT=Treat N S NS NA SS/nouni ss3;
     manova h=treat N S NS NA SS;
run;
title2 'Joint test that all covariates are zero';
proc reg data=Roh2;
     model PPVT RPMT SAT=one1 one2 N S NS NA SS/noint;
	 Joint: mtest N, S, NS, NA, SS/print;
	 N: mtest n;
	 S: mtest s;
	 NS:mtest NS;
	 NA:mtest NA;
	 SS:mtest SS;
run;
/* MANCOVA Tests === Assumming parallelism*/
title2 'Mancova tests';
proc glm data=Roh2;
     class treat;
     model PPVT RPMT SAT=Treat NS NA/solution ss3;
     means treat;
     lsmeans treat/pdiff=all cl adjust=tukey alpha=.0167 cov out=adjmeans;
     output out=res p=hppvt hrpmt hsat r=rppvt rrpmt rsat;
     manova h=treat NS NA/ canonical printe printh;
     contrast '1vs2' treat 1 -1;
     manova m=(1 0 0);
     manova m=(0 1 0);
     manova m=(0 0 1);
     manova m=(1 1 1);
     estimate '1vs2'   treat 1 -1;
run;
proc print data=adjmeans;
     title2 'Adjusted Means';
run;
proc plot data=res;
     plot rppvt*hppvt;
     plot rrpmt*hrpmt;
     plot rsat*hsat;
run;
proc univariate data=res normal plot;
     var rppvt rrpmt rsat;
	 qqplot/normal (mu=est sigma=est);
run;
%multnorm(data=res,var=rppvt rrpmt rsat, plot=yes);
quit;

/* Construct Confidence Intervals */

proc transreg data=Roh2 ss2 short;
     model identity(PPVT RPMT SAT NS NA)=class(treat/zero=none);
     output out=new;
run;
proc iml;
     use new;
     read all var {treat1 treat2 NS NA} into x;
     read all var {PPVT RPMT SAT} into y;
n=nrow(x);
k=ncol(x);
p=ncol(y);
v=inv(x`*x);
A=v*x`*y;print A;
E=(y`*y-y`*x*A);print e;
S=E/(n-k);
C={1  -1 0 0};
H=(C*A)`*inv((C*v*C`))*(C*A);
print H S;
newe=n-k;
newh=1;
new1=max(newh,p);
alpha=.05;
newd=newe-new1+newh;
co_2=newe*(new1/newd)*finv(1-alpha,new1,newd);
co=sqrt(co_2);print co;
c1={1 -1 0 0};
m={1 0 0};
psi=c1*A*m`;print psi;
sdpsi=sqrt((m*s*m`)*(c1*v*c1`));
cLpsi=psi-co*sdpsi;
cUpsi=psi+co*sdpsi;
print ' Simultaneous Confidence Interval for Treatment 1 vs 2 for PPVT';
print 'contrast' c1;
print 'post m '  m;
print 'Confidence Limits:('cLpsi','cUpsi')';
quit;
run;
/* MANCOVA stepdown analysis for aditional information  */
title2 'Test of additional information ';
proc glm data=Roh2;
     class treat;
     model SAT RPMT = Treat PPVT NS NA/nouni ss3;
     manova h= Treat PPVT NS NA/printe printh;
run;
