/* ********************************************/
/* Program M4_7_1.sas                         */
/* Test of location, Multlple Groups          */
/* Chi-Square and Johansen's Method           */
/* ********************************************/

options ls=80 nodate formdlim='o' pageno=1;

data Stan;

   infile 'e:\Stan_hz.dat';
   input Grp $ Low High;
   if _n_ =82 then delete;
   run;
title1 'Test of Location: Normal Data with Unequal Variance-Covariance Matrices';
title2 'Using the chi-square statistic';
proc iml;
   use stan;
   read all var {low high} where (grp='AA') into y1;
   read all var {low high} where (grp='C') into y2;
   read all var {low high} where (grp='NC') into y3;
   k=3;
   p=2;
   n1=nrow(y1);
   n2=nrow(y2);
   n3=nrow(y3);
   n=n1+n2+n3;
   p=ncol(y1);
   df1=n1-1;
   df2=n2-1;
   df3=n3-1;
   e1=(y1`*(i(n1)-(1/n1)*j(n1,n1))*y1);print E1;
   e2=(y2`*(i(n2)-(1/n2)*j(n2,n2))*y2);print E2;
   e3=(y3`*(i(n3)-(1/n3)*j(n3,n3))*y3);print E3;
   s1=e1/df1;print s1;
   s2=e2/df2;print s2;
   s3=e3/df2;print s3;
   w1=s1#(1/n1);
   w2=s2#(1/n2);
   w3=s3#(1/n3);
   w=w1+w2+w3;
   y1m=y1[:,];print 'mean' y1m;
   y2m=y2[:,];print 'mean' y2m;
   y3m=y3[:,];print 'mean' y3m;
   ybar=(n1*y1m+n2*y2m+n3*y3m)/n;print ybar;
   d1=y1m-ybar;d2=y2m-ybar;d3=y3m-ybar;
/* Chi-Square Statistic*/
   xsquare=d1*w1*d1`+d2*w2*d2`+d3*w3*d3`;
   print 'Chi-square statistic' xsquare;
   new_h=p*(k-1);print 'df' new_h;
   cr_val=cinv(.95,new_h);print 'Chi-square Critical Value' cr_val;
   p_val=1-probchi(xsquare,new_h);print 'Pval' p_val;

/*F Statistic*/
   t1=inv(w)*inv(w1);t11=i(2)-t1;
   t2=inv(w)*inv(w2);t22=i(2)-t2;
   t3=inv(w)*inv(w3);t33=i(2)-t3;
   a1=(trace(t11**2)/df1)+(trace(t22**2)/df2)+(trace(t33**2)/df3);
   a2=(trace(t11)**2/df1)+(trace(t22)**2/df2)+(trace(t33)**2/df3);
   a=a1+a2;
   f=p*(p+2)/3*a;
   c=p+2*a-(6*a/(p*(p-1)+2));
   fval=c*finv(.95,p,f);
   print 'F Adjusted Chi-Square Critical Value=' fval;
   p_valf=1-probchi(fval,new_h);
   print 'Johansen p-value=' p_valf;
quit;
