/*********************************************/
/* Program m4_9_1.sas                        */
/* Two-Way MANOVA                            */
/* Study by Joseph Raffaele                  */
/*********************************************/

options ls = 80 nodate pageno=1 formdlim='o';

filename multnorm 'e:multnorm.sas';
%include multnorm;

data twoa;
Title1 ' Two-Way MANOVA Analysis';
   infile 'e:\twoa.dat';
   input T $ C $ rate comp;
run;
proc print data=twoa;
/* MANOVA Tests*/
title2 'Manova tests';
proc glm data=twoa;
     class t c;
     model Rate Comp=T C T*C/ss3;
     means T C T*C;
     lsmeans C/pdiff=all cl adjust=tukey alpha=.025;
     output out=res p=yhatr yhatc r=resr resc;
     manova h=T C T*C/canonical printe printh;
     contrast 'c1-c2' C 1  -1;
     contrast '11-31-12+32'  T*C 1 -1 0  0 -1 1;
     contrast '21-31-22+32'  T*C 0  0 1 -1 -1 1;
     contrast '11-12-21+22'  T*C 1 -1 -1 1  0 0;
     manova m=(1 0);
     manova m=(0 1);
     estimate 'c1-c2'   C 1  -1;
     estimate '11-31-12+32'  T*C 1 -1  0  0 -1 1;
     estimate '21-31-22+32'  T*C 0  0  1 -1 -1 1;
run;
proc gplot data=res;
     plot resr*yhatr;
     plot resc*yhatc;
run;
/* Confidence Intervals for MANOVA*/
proc transreg data=twoa ss2 short;
     model identity(rate comp)=class(T*C/zero=none);
     output out=new1;
run;
proc print data=new1;
proc iml;
     use new1;
     read all var {TT1CC1 TT1CC2 TT2CC1 TT2CC2
                   TT3CC1 TT3CC2} into x;
     read all var {rate comp} into y;
n=nrow(x);
k=ncol(x);
p=ncol(y);
vv=inv(x`*x);
A=vv*x`*y;print A;
E=(y`*y-y`*x*A);print e;
S=E/(n-k);
C={ 1 -1 0  0 -1 1,
    0  0 1 -1 -1 1};
H=(C*A)`*inv((C*vv*C`))*(C*A);
print H S;
newe=n-k;
newh=nrow(c);
new1=max(newh,p);
ss=min(newh,p);
mm=(abs(newh-p)-1)/2;
nn=(newe-p-1)/2;
BLH1=ss*(2*mm+ss+1);
BLH2=2*(ss*nn+1);
BNP1=ss*(2*mm+ss+1);
BNP2=ss*(2*nn+ss+1);
alpha=.05;
newd=newe-new1+newh;
co_2=newe*(new1/newd)*finv(1-alpha,new1,newd);
co_R=sqrt(co_2);print 'ROY approx Critical Value' co_R;
coBLH_2=(newe*(ss*BLH1/BLH2))*finv(1-alpha,BLH1,BLH2);
co_BLH=sqrt(coBLH_2); print 'BLH approx Critical Value' co_BLH;
num=(ss*bnp1/bnp2)*finv(1-alpha,bnp1,bnp2);
den=1+((bnp1/bnp2)*finv(1-alpha,bnp1,bnp2));
v=num/den;
coBNP_2=newe*(v/(1-v));
co_BNP=sqrt(coBNP_2); print 'BNP approx Critical value' co_BNP;
c1={1 -1 0 0 -1 1};
m={ 0 1};
psi=c1*A*m`;
sdpsi=sqrt((m*s*m`)*(c1*vv*c1`));
cLpsi=psi-co_R*sdpsi;
cUpsi=psi+co_R*sdpsi;
print 'Approx Interval for Treatment 1 vs 3 for Reading Comp-- ROY';
print 'contrast' c1;
print 'post m '  m;
print 'Confidence Limits:('cLpsi','cUpsi')';
quit;
/* Evaluation of Normality for MANOVA */
proc univariate data=res normal;
     var resr resc;
	 qqplot /normal (mu=est sigma=est);
run;
%multnorm(data=res,var=resr resc, plot=yes);
quit;
