/*********************************************/
/* Program m4_9_2.sas                        */
/* Two-way MANCOVA                           */
/* High/Low SES vs Treatments with a Control */
/*                                           */
/*********************************************/

options ls = 80 nodate pageno=1 formdlim='o';

filename multnorm 'e:\multnorm.sas';
%include multnorm;

/* MANCOVA Tests*/
data twoc;
Title1 ' Two-Way MANCOVA Analysis';
   infile 'e:\twoc.dat';
   input B $ T $ yr ym zr zm;
proc print data=twoc;
title2 'Test of Parallelism using PROC GLM';
proc glm data=twoc;
     class T B;
     model yr ym=B*T zr zm
                     b*t*zr b*t*zm/nouni noint ss3;
    manova h= b*t*zr b*t*zm;
run;
title2 'Mancova Tests';
proc glm data=twoc;
     class T B;
     model yr ym=T B B*T zr zm/solution ss3;
     means  T B T*B;
     lsmeans T/pdiff=control cl adjust=dunnett alpha=.025 cov out=adjmeans;
     output out=res1 p=yhr yhm r=ry rm;
     manova h=T B B*T zr zm/ printe printh;
     contrast 'c-e1' t 1 0 -1;
     contrast 'c-e2' t 0 1 -1;
     manova m=(1 0);
     manova m=(0 1);
     estimate 'c-e1'   t 1 0 -1;
     estimate 'c-e2'   t 1 -1 0;
run;
proc print data=adjmeans;
/* Confidence Intervals for MANCOVA*/
proc transreg data=twoc ss2 short;
     model identity(yr ym zr zm)=class(B*T/zero=none);
     output out=new;
run;
proc print data=new;
title2 'Test all covariates simultaneously zero';
proc reg data=new;
model yr ym =BFTC BFTE1 BFTE2 
             BMTC BMTE1 BMTE2 zr zm/noint;
gamma_0: mtest zr,zm/print;
run;
proc iml;
     use new;
     read all var {BFTC BFTE1 BFTE2
                   BMTC BMTE1 BMTE2 zr zm} into x;
     read all var {yr ym} into y;
n=nrow(x);
k=ncol(x);
p=ncol(y);
vv=inv(x`*x);
A=vv*x`*y;print A;
E=(y`*y-y`*x*A);print e;
S=E/(n-k);
C={1 0 -1 1 0 -1 0 0,
   0 1 -1 0 1 -1 0 0};
H=(C*A)`*inv((C*vv*C`))*(C*A);
print H S;
newe=n-k;
newh=nrow(c);
new1=max(newh,p);
ss=min(newh,p);
mm=(abs(newh-p)-1)/2;
nn=(newe-p-1)/2;
BLH1=ss*(2*mm+ss+1);
BLH2=2*(ss*nn+1);
BNP1=ss*(2*mm+ss+1);
BNP2=ss*(2*nn+ss+1);
alpha=.05;
newd=newe-new1+newh;
co_2=newe*(new1/newd)*finv(1-alpha,new1,newd);
co_R=sqrt(co_2);print 'ROY approx Critical Value' co_R;
coBLH_2=(newe*(ss*BLH1/BLH2))*finv(1-alpha,BLH1,BLH2);
co_BLH=sqrt(coBLH_2); print 'BLH approx Critical Value' co_BLH;
num=(ss*bnp1/bnp2)*finv(1-alpha,bnp1,bnp2);
den=1+((bnp1/bnp2)*finv(1-alpha,bnp1,bnp2));
v=num/den;
coBNP_2=newe*(v/(1-v));
co_BNP=sqrt(coBNP_2); print 'BNP approx Critical value' co_BNP;

c1={-.5 0 .5 -.5 0 .5  0 0};
m= {0 1};
/* rerun with m ={1 0} for interval on second variable*/
psi=c1*A*m`;print psi;
sdpsi=sqrt((m*s*m`)*(c1*vv*c1`));
cLpsi=psi-co_R*sdpsi;
cUpsi=psi+co_R*sdpsi;
print 'Approx CI for Control vs E2 variable Math ---ROY ';
print 'contrast' c1;
print 'post m '  m;
print 'Confidence Limits:('cLpsi','cUpsi')';
quit;
/* Normality for MANCOVA Model*/
proc univariate data=res1 normal plot;
     var ry rm;
	 qqplot /normal (mu=est sigma=est);
run;
%multnorm(data=res1,var=ry rm, plot=yes);
quit;
