/****************************************************/
/* Program 5_13_1.sas                               */
/*                                                  */
/* Analysis of Sum of Profiles Model                */
/* Using the CGMANOVA/SUR Model of  Hecker(1987)    */
/* Data are from Danford et al. (1960)              */
/* Also analyzed by Chinchille and Elswick(1985)    */
/* Using the Manova-Gmanova Model                   */
/*                                                  */
/****************************************************/

options ls=80 nodate pageno=1 formdlim='o';
title1 'Sum of Profiles Model';

filename multnorm 'e:\multnorm.sas';
%include multnorm;

data Danford;
   infile 'e:\Danford.dat';
   input group d1 d2 d3 d4 z1 y1 - y5;
run;
proc print data=Danford;
%multnorm(data=Danford,
          var=y1 y2 y3 y4 y5,
                  plot=yes);
run;
proc summary data=Danford;
   class group;
   var y1 - y5 z1;
   output out=new1 mean= y1 - y5 z1;
proc print data=new1;
run;
data plot;
   set new1;
   array mr(5) y1 - y5;
   do time = 1 to 5;
      response = mr(time);
      output;
   end;
   drop mr1 - mr5;
proc plot;
   plot response*time=group;
run;

proc iml;
   use Danford;
   read all var {y1 y2 y3 y4 y5} into y;
   read all var {d1 d2 d3 d4}  into x1;
   read all var {d1 d2 d3 d4 z1} into x;
   read all var {z1} into z;
   t={1 2 3 4 5};
   p_prime=orpol(t,4);
   p=p_prime[1:5,1:2];
   x2=p`;
   n=nrow(y);
   k=ncol(y);
   one=j(n,1,1);
   sigma=(y`*y-y`*one*inv(one`*one)*one`*y)/n;
   print 'Consistent Estimator of Covariance Matrix', sigma;
   d1=x1@x2`; d2=z@i(5);
   d=d1||d2;
   yc=shape(y,225,1,0);
   v=i(n)@inv(sigma);
   theta=inv(d`*v*d)*d`*inv((i(n)@sigma))*yc;
   print 'GLSE of Parameter Matrix', Theta;
   /* Test of Coincidence  */
   c={1 0 0 0 0 0 -1  0 0 0 0 0 0,
      0 1 0 0 0 0  0 -1 0 0 0 0 0,
      0 0 1 0 0 0 -1  0 0 0 0 0 0,
      0 0 0 1 0 0  0 -1 0 0 0 0 0,
      0 0 0 0 1 0 -1  0 0 0 0 0 0,
      0 0 0 0 0 1  0 -1 0 0 0 0 0};
   w=(c*theta)`*inv(c*inv(d`*v*d)*c`)*(c*theta);
   df=6;
   pvalue=1-probchi(w,df);
   print 'Wald Statistic for Coincidence',w df pvalue;
   /* Test Gamma0 equals zero   */
   c={0 0 0 0 0 0 0 0 1 0 0 0 0,
      0 0 0 0 0 0 0 0 0 1 0 0 0,
      0 0 0 0 0 0 0 0 0 0 1 0 0,
      0 0 0 0 0 0 0 0 0 0 0 1 0,
      0 0 0 0 0 0 0 0 0 0 0 0 1};
   w=(c*theta)`*inv(c*inv(d`*v*d)*c`)*(c*theta);
   df=5;
   pvalue =1-probchi(w,df);
   print 'Wald Statistic for Gamma0=0',w df pvalue;
quit;
run;
