/*********************************************/
/* Program m5_14_1.sas                       */
/*                                           */
/* Program for the Analysis of Cox's Test    */
/* And the F-like test f_star for Nonnested  */
/* Sur Models                                */
/* Analysis of a subset of Rohwer's Data     */
/*********************************************/

options ls=80 pageno=1  nonumber formdlim='o';
title1 'Rohwer Data for Nonnested Sur Model Example';
data Rohwer;
infile 'e:\Rohwer.dat';
input sat ppvt rpmt one n s ns na ss;

/* CODE FOR TESTING H0 VERSUS H1*/

proc print data=Rohwer;
run;
ods listing close;
ods output CovResiduals = s0_01; 
ods output ParameterEstimates=bhat_01;
proc syslin itsur out=new;
     title2 'H0 Model';
     endogenous sat ppvt;
     instruments ss n s;
     sat:  model sat=n ss;
           output p=h_sat;
     ppvt: model ppvt= s ss;
           output p=h_ppvt;
run;
ods output CovResiduals = s1_01; 
proc syslin itsur data=rohwer;
     title2 'H1 Model';
     endogenous sat ppvt;
     instruments na ns ss;
     sat:  model sat=na ss;
     ppvt: model ppvt= ns ss;
run;
ods output CovResiduals = error_01; 
ods output ParameterEstimates=gtlda_01;
proc syslin itsur data=new;
     title2 'Artificial Regression SUR Model';
     endogenous h_sat h_ppvt;
     instruments na ns ss;
     sat:  model h_sat= na ss;;
     ppvt: model h_ppvt= ns ss;
run;
ods output CovResiduals = s0_10; 
ods output ParameterEstimates=bhat_10;

/* CODE FOR TESTING H1 VERSUS H0  */
proc syslin itsur data=Rohwer out=new1;
     title2 'H1 Model';
     endogenous sat ppvt;
     instruments na ns ss;
     sat:  model sat=na ss;
           output p=h_sat;
     ppvt: model ppvt=ns ss;
           output p=h_ppvt;
run;
ods output CovResiduals = s1_10; 
proc syslin itsur data=rohwer;
     title2 'H0 Model';
     endogenous sat ppvt;
     instruments ss n s;
     sat:  model sat=n ss;
     ppvt: model ppvt=s ss;
run;
ods output CovResiduals = error_10; 
ods output ParameterEstimates=gtlda_10;

proc syslin itsur data=new1;
     title2 'Artificial Model';
     endogenous h_sat h_ppvt;
     instruments n s ss;
     sat:   model h_sat= n ss;
     ppvt:  model h_ppvt=s ss;
run;

/* END OF SYSLIN CODE FOR COX'S TEST  */
ods listing;

/*Testing Nonnested SUR Hypotheses */
/* CODE FOR COX'S Test of H0 vs H1 */

title1 'Coxs Test of HO Vs H1 ';
proc iml;
use Rohwer;
read all var {sat} into y1;
read all var {ppvt} into y2;
read all var {n ss} into x1;
read all var {s ss} into x2;
read all var {one} into one;
n0=nrow(x1);
p=Ncol(x1);
x11=one||x1;x22=one||x2;
x=block(x11,x22);
yo=y1//y2;
read all var {na ss} into z1;
read all var {ns ss} into z2;
z11=one||z1;
z22=one||z2;
z=block(z11,z22);
use s0_01;
read all var {sat ppvt} into s0_01;
use s1_01;
read all var {sat ppvt} into s1_01;
use error_01;
read all var {sat ppvt} into error_01;
use bhat_01;
read all var {Estimate} into bhat_01;
bhat_01=bhat_01[Ncol(x)+1:Nrow(bhat_01),];
use gtlda_01;
read all var {Estimate} into gtlda_01;
gtlda_01=gtlda_01[Ncol(x)+1:Nrow(gtlda_01),];
s10_01=error_01+s0_01;
T0=n0*log(det(s1_01)/det(s10_01));
print s0_01, bhat_01, s1_01, gtlda_01, s10_01, T0;
omega0=s0_01@i(n0);
delta=x*bhat_01-z*gtlda_01;
h0=((s0_01*inv(s10_01))@i(n0))*delta;
iomega=inv(omega0);
d0=(i(2*n0)-(x*inv(x`*iomega*x)*x`*iomega))*h0;
v0=sqrt(d0`*iomega*d0);
print V0;
z01=T0/v0;
print 'Coxs test of H0 vs H1' z01;
/*--------------------------------*/

/* COD OF COX'S TEST OF H1 VS H0   */
title1 'Coxs test of H1 Vs H0';
use Rohwer;
read all var {na ss} into x1;
read all var {ns ss} into x2;
read all var {one} into one;
read all var {n ss} into z1;
read all var {s ss} into z2;
x11=one||x1;x22=one||x2;
x=block(x11,x22);
z11=one||z1;
z22=one||z2;
z=block(z11,z22);
use s0_10;
read all var {sat ppvt} into s0_10;
use s1_10;
read all var {sat ppvt} into s1_10;
use error_10;
read all var {sat ppvt} into error_10;
use bhat_10;
read all var {Estimate} into bhat_10;
bhat_10=bhat_10[Ncol(x)+1:Nrow(bhat_10),];
use gtlda_10;
read all var {Estimate} into gtlda_10;
gtlda_10=gtlda_10[Ncol(x)+1:Nrow(gtlda_10),];
s10_10=error_10+s0_10;
print s0_10,bhat_10,s1_10,gtlda_10,s10_10;
T0=n0*log(det(s1_10)/det(s10_10));
print T0;
omega0=s0_10@i(n0);
delta=x*bhat_10-z*gtlda_10;
h0=((s0_10*inv(s10_10))@i(n0))*delta;
iomega=inv(omega0);
d0=(i(2*n0)-(x*inv(x`*iomega*x)*x`*iomega))*h0;
v0=sqrt(d0`*iomega*d0);
print V0;
z10=T0/v0;
print 'Coxs test of H1 vs H0' z10;
quit;

/* SAS  PROGRAM FOR F-LIKE TESTS   */
/* TESTING NONNESTED SUR HYPOTHESES*/

title1 'F-like Test of H0 Vs H1';
data Rohwer;
infile 'e:\Rohwer.dat';
input sat ppvt rpmt one n s ns na ss;
ods listing close;
proc syslin itsur out=new;
   title2 'H0 Model';
   endogenous sat ppvt;
   instruments ss n s;
   sat:  model sat=n ss;
         output p=h_sat;
   ppvt: model ppvt= s ss;
         output p=h_ppvt;
run;
proc syslin itsur data=new out=new2;
   title2 'Artificial Model';
   endogenous h_sat h_ppvt;
   instruments na ns ss;
   sat: model h_sat= na ss;
        output r=r_sat;
   ppvt:model h_ppvt= ns ss;
        output r=r_ppvt;
run;
ods output CovResiduals = s_s01; 
proc syslin itsur data=new2;
   endogenous sat ppvt;
   instruments na ns ss r_sat r_ppvt;
   sa: model sat=na ss r_sat;
   pv: model ppvt=ns ss r_ppvt;
   stest sa.r_sat=0,pv.r_ppvt=0;
run;
ods listing;
proc iml;
use new2;
read all var {sat} into y1;
read all var {ppvt} into y2;
read all var {na ss} into x1;
read all var {ns ss} into x2;
read all var {one} into one;
read all var {r_sat} into r1;
read all var {r_ppvt} into r2;
use s_s01;
read all var {sa pv} into s_s;
fhat=r1//r2;
n0=nrow(x1);
p=ncol(x1);
x11=one||x1;x22=one||x2;
x=block(x11,x22);
yo=y1//y2;
omega_s=s_s@i(n0);
print fhat;
x_s=x||fhat;
iomega=inv(omega_s);
theta=inv(x_s`*iomega*x_s)*x_s`*iomega*yo;
print theta;
err=(yo-x_s*theta)`*iomega*(yo-x_s*theta);
print err;
R={0 0 0 0 0 0 1};
num=(R*theta)`*inv(R*inv(x_s`*iomega*x_s)*R`)*(R*theta)`;
fstar=(n0*2*p-7)*num/err;
print fstar;
r_fstar=root(fstar);
print 'Square root of Fstar for testing H0 vs H1' r_fstar;
quit;

/*CODE FOR TESTING H1 VERSUS H0   */
title1 'F-like Test of H1 Vs H0';
data Rohwer; 
infile 'e:\Rohwer.dat';
input sat ppvt rpmt one n s ns na ss;
ods listing close;
proc syslin itsur out=new;
     title2 'H1 Model';
     endogenous sat ppvt;
     instruments ss na ns;
     sat:  model sat=na ss;
           output p=h_sat;
     ppvt: model ppvt= ns ss;
           output p=h_ppvt;
run;
proc syslin itsur data=new out=new2;
     title2 'Artificial Model';
     endogenous h_sat h_ppvt;
     instruments n s ss;
     sat: model h_sat= n ss;
          output r=r_sat;
     ppvt: model h_ppvt= s ss;
           output r=r_ppvt;
run;
ods output CovResiduals = s_s10; 
proc syslin itsur data=new2;
     endogenous sat ppvt;
     instruments n s ss r_sat r_ppvt;
     sa: model sat=n ss r_sat;
     pv: model ppvt=s ss r_ppvt;
     stest sa.r_sat=0,pv.r_ppvt=0;
run;
ods listing;
proc iml;
use new2;
read all var {sat} into y1;
read all var {ppvt} into y2;
read all var {n ss} into x1;
read all var {s ss} into x2;
read all var {one} into one;
read all var {r_sat} into r1;
read all var {r_ppvt} into r2;
use s_s10;
read all var {sa pv} into s_s;
fhat=r1//r2;
n0=nrow(x1);
p=ncol(x1);
x11=one||x1;x22=one||x2;
x=block(x11,x22);
yo=y1//y2;
omega_s=s_s@i(n0);
print fhat;
x_s=x||fhat;
iomega=inv(omega_s);
theta=inv(x_s`*iomega*x_s)*x_s`*iomega*yo;
print theta;
err=(yo-x_s*theta)`*iomega*(yo-x_s*theta);
print err;
R={0 0 0 0 0 0 1};
num=(R*theta)`*inv(R*inv(x_s`*iomega*x_s)*R`)*(R*theta)`;
fstar=(n0*2*p-7)*num/err;
print fstar;
r_fstar=root(fstar);
print 'Square Root of Fstar for testing H1 Us H0' r_fstar;
quit;

/* END OF CODE FOR F-LIKE TESTS  */