/********************************************/
/* Program m5_3_1.sas                       */
/* Rohwer data from Timm(1975), pp.281,345  */
/* Fit SUR model to the data                */
/********************************************/

options ls = 80 nodate pageno=1 formdlim='o';
title1 ' Seemingly Unrelated Regression Model';
filename multnorm 'e:\multnorm.sas';
%include multnorm;
data rohwer;
   infile 'e:\rohwer.dat';
   input ppvt rpmt sat one n s ns na ss;
run;
proc print data=rohwer;
run;
title2 'Full Multivariate Regression Model';
proc syslin data=Rohwer;
     ppvt: model ppvt = n s ns na ss;
     rpmt: model rpmt = n s ns na ss;
         sat : model sat  = n s ns na ss;
   Test_N: Stest ppvt.n=rpmt.n=sat.n=0;
  Test_SS: Stest ppvt.ss=rpmt.ss=sat.ss=0;
run;
proc syslin data=Rohwer;
title2 'Reduced Multivariate Regression Model';
     ppvt: model ppvt = s ns na;
         rpmt: model rpmt = s ns na;
         sat : model sat  = s ns na;
  Test_NA: Stest ppvt.na=rpmt.na=sat.na=0;
  Test_S : Stest ppvt.s=rpmt.s=sat.s=0;
  Test_NS: Stest ppvt.ns=rpmt.ns=sat.ns=0;
         run;
/* SUR Model Using PROC SYSLIN */
proc syslin FIML out=fit;
   title2 'Using PROC SYLIN with FIML option';
   PPVT: model ppvt = na;
         output p=h_ppvt r=r_ppvt;
   RPMT: model rpmt = s;
         output p=h_rpmt r=r_rpmt;
   SAT:  model sat =  ns na;
         output p=h_sat r=r_sat;
   Test: Stest ppvt.na=sat.na=0;
run;
proc print data=fit;
     proc plot data=fit;
         plot r_sat*h_sat;
         plot r_ppvt*h_ppvt;
         plot r_rpmt*h_rpmt;
run;
%multnorm(data=fit,
          var=r_ppvt r_rpmt h_sat,
                  plot=yes);
run;
proc syslin itsur;
   title2 'Using PROC SYLIN with ITSUR option';
   PPVT: model ppvt = na;
   RPMT: model rpmt = s;
   SAT:  model sat =  ns na;
run;
proc syslin sur;
   title2 'Using PROC SYLIN with SUR option';
   PPVT: model ppvt = na;
   RPMT: model rpmt = s;
   SAT:  model sat =  ns na;
run;
