/*****************************************/
/* Program m5_5_1.sas                    */
/* Data from Timm(1975, page 454)        */
/* Repeated Measures Analysis            */
/* Extended Linear Hypotheses            */
/* Using the SUR Model                   */
/*****************************************/
options ls=80 ps=60 nodate pageno=1 formdlim='o';
title1 ' Repeated Measurement Analysis using SUR Model';

data timm;
   infile 'e:Timm454.dat';
   input group y1 y2 y3 x1 x2 x3;
proc print data=timm;
proc syslin itsur data=timm;
   y1: model y1=x1 x2 x3/noint;
   y2: model y2=x1 x2 x3/noint;
   y3: model y3=x1 x2 x3/noint;
   Group: Stest   y1.x1=y2.x1=y3.x1,
                  y1.x2=y2.x2=y3.x2,
                          y1.x3=y2.x3=y3.x3;
   Cond:  Stest   y1.x1=y1.x2=y1.x3,
                  y2.x1=y2.x2=y2.x3,
                                  y3.x1=y3.x2=y3.x3;
   GxC:   Stest y1.x1-y3.x1-y1.x3+y3.x3=0,
                y2.x1-y3.x1-y2.x3+y3.x3=0,
                                y1.x2-y3.x2-y1.x3+y3.x3=0,
                                y2.x2-y3.x2-y2.x3+y3.x3=0;
   H1:    Stest y1.x1+y2.x2+y3.x3-.5*y2.x1+.5*y1.x2-
                .5*y3.x1+.5*y1.x3-.5*y2.x3+.5*y3.x3=0;
   H2:    Stest y1.x1=y1.x2,
                y2.x1=y2.x2=y2.x3,
                                y3.x2=y3.x3;
   H3:    Stest y1.x1-y2.x1+y2.x2-y3.x2+y1.x3-y3.x3=0;
run;
