/***********************************************************/
/* Program m5_5_2.sas                                      */
/* GMANOVA/SUR Several Groups Edward's Data                */
/***********************************************************/

options ls = 80 nodate pageno=1 formdlim='o';
title1 'GMANOVA-SUR Several Population Edwards Data';

data timm;
   infile'e:\timm454.dat';
   input group y1 y2 y3 x1 x2 x3;
proc print data=timm;
run;
proc summary data=timm;
   class group;
   var y1 -y3;
   output out=new mean=mr1-mr3;
proc print data=new;
run;
data plot;
     set new;
         array mr(3) mr1-mr3;
         do time = 1 to 3;
            response =mr(time);
                output;
         end;
drop mr1-mr3;
proc plot;
     title2 ' Growth Curve Plots of Group Means';
         plot response*time=group;
         run;
proc iml;
   use timm;
   read all var {y1 y2 y3} into y;
   read all var {Group} into gr;
   read all var {x1 x2 x3} into x;
   /* Create Orthogonal Polynomials of degree  q-1=2 */
   z={1 2 3};
   P_prime=orpol(z,2);
   Y0=Y*P_prime;
   print 'P prime matrix',P_prime;
   t=y0||x||gr;
   /* Create New Transformed data set */
   varnames={yt1 yt2 yt3 x1 x2 x3 group};
   create trans from t (|colname=varnames|);
   append from t;
quit;
proc print data=trans;
run;

/* Test model fit  */
proc glm data=trans;
   title2 ' Test of Model Fit';
   model yt3=/nouni;
   manova h=intercept;
run;
proc glm data=timm;
   class group;
   model y1 -y3=group/nouni;
   repeated time polynomial/summary nom nou;
   run;
/* Using a Rao-Khatri MANCOVA model         */
/* Test for group differences (coincidence) */
proc glm data=trans;
title2 'Gmanova Model';
   class group;
   model yt1 - yt2 = group yt3/nouni;
   manova h=group/printh printe;
run;

/* Estimate of the matrix B */
proc glm data=trans;
   title2 'Estimate of B using PROC GLM';
   class group;
   model yt1 - yt2 = group yt3;
   estimate 'beta1' intercept 1 group 1 0 0;
   estimate 'beta2' intercept 1 group 0 1 0;
   estimate 'beta3' intercept 1 group 0 0 1;


/* Estimate of B using syslin procedure */
proc syslin sur data=trans;
   title2 'Estimate of B using PROC SYSLIN';
   one:   model yt1 = x1 x2 x3 yt3/noint;
   coin1: test x1=x2=x3;
   two:   model yt2 = x1 x2 x3 yt3/noint;
   coin2: test x1=x2=x3;
   parll: stest one.x1=two.x1=0,
                one.x2=two.x2=0;
run;
