/**********************************************/
/* Program 5_7_1.sas                          */
/* GMANOVA - SUR (Elston and Grizzle, 1962)   */
/**********************************************/
options ls=80 nodate pageno=1 formdlim='o';
filename multnorm 'e:\multnorm.sas';
%include multnorm;

title1 ' One Population Ramus Height Data';

data ramus;
   infile'e:\ramus.dat';
   input group y1 y2 y3 y4;
proc print data=ramus;
run;
proc summary data=ramus;
   class group;
   var y1 -y4;
   output out=new mean=mr1-mr4;
proc print data=new;
run;
data plot;
   set new;
   array mr(4) mr1-mr4;
   do time = 1 to 4;
      response = mr(time);
      output;
   end;
   drop mr1-mr4;
run;
proc plot;
   title2 'Plot of Ramus Heights';
    plot response*time=group;
run;

/* Informal Evaluation of Trend  */
proc glm data=ramus;
title2 ' Informal Evaluation of Trend';
   class group;
   model y1 - y4=group/nouni;
   repeated time polynomial/summary nom nou;
   run;

proc iml;
   use ramus;
   read all var {y1 y2 y3 y4} into y;
   read all var {Group} into x;
   y1=y[1:20,1:1]; y2=y[1:20,2:2]; y3=y[1:20,3:3];y4=y[1:20,4:4];
   vecy=y1//y2//y3//y4;
   n=nrow(x);
   k=ncol(x);
   xpx=x`*x;
   xpxi=inv(xpx);
   s=(y`*y-y`*x*xpxi*x`*y)/(n-k);
   si=inv(s);
   print s;
   /*Create Orthogonal Polynomials q-1=3 */
   z={1 2 3 4};
   p_prime=orpol(z,3);
   p=p_prime[1:4,1:2];
   /* Estimate of B using SUR model  */
   beta=((inv(p`*si*p)*p`*si)@(xpxi*x`))*vecy;
   print 'Estimate of B using SUR estimate and PROC IML', beta;
   Y0=Y*P_prime*inv(p_prime`*p_prime);
   print 'P prime matrix',P_prime;
   t=y0||x;
   varnames={yt1 yt2 yt3 yt4 x};
   create trans from t (|colname=varnames|);
   append from t;
quit;
run;

/* Test linear model fit or adequacy Gmanova Model  */
proc glm data=trans;
   title2 'Formal Test of Linear Fit';
   model yt3 yt4=/nouni;
   manova h=intercept;
run;

/* Estimate of B using a Rao-Khatri MANCOVA model  */
proc glm data=trans;
   title2 'Estimate of B using PROC GLM and Test B=0';
   class x;
   model yt1 yt2 = x yt3 yt4;
   output out=res p=yhat1 yhat2 r=res1 res2;
   manova h=intercept;
   estimate 'beta' intercept 1 x 1;
run;
proc reg data=trans;
   title2 'Estimate of B using PROC Reg and Test B=0';
   model yt1 yt2 = yt3 yt4;
   b:  mtest intercept=0;
run;
proc plot data=res;
     plot res1*yhat1;
         plot res2*yhat2;
run;
proc univariate data=res normal plot;
     var res1 res2;
run;
%multnorm(data=res,var=res1 res2, plot=yes);
quit;
/* Estimate of B using syslin procedure */
proc syslin sur data=trans;
   title2 'Estimate of B using PROC SYSLIN';
   yt1: model yt1 = x yt3 yt4/noint;
   test1: test x=0;
   yt2: model yt2 = x yt3 yt4/noint;
   test2: test x=0;
   over: Stest yt1.x=yt2.x=0;
run;
