/*********************************************************/
/* Program m5_7_2.sas                                    */
/* GMANOVA/SUR Several Edward's Data                     */
/*********************************************************/

options ls = 80 nodate pageno=1 formdlim='o';
title1 'GMANOVA-SUR Several Population Edwards Data';

data Timm;
   infile'e:\Timm454.dat';
   input group y1 y2 y3 x1 x2 x3;
proc print data=timm;
run;
proc summary data=timm;
   class group;
   var y1 - y3;
   output out=new mean=mr1-mr3;
proc print data=new;
run;
data plot;
     set new;
         array mr(3) mr1-mr3;
         do time = 1 to 3;
         response = mr(time);
         output;
         end;
         drop mr1-mr3;
proc plot;
     title2 ' Growth Curve Plots of Group Means';
         plot response*time=group;
run;
proc glm data=timm;
   class group;
   model y1 - y3 = group/nouni;
   repeated time polynomial/summary nom nou;

run;

proc iml;
   use timm;
   read all var {y1 y2 y3} into y;
   read all var {Group} into gr;
   read all var {x1 x2 x3} into x;
   /* Create Orthogonal Polynomials of degree  q-1=2 */
   z={1 2 3};
   P_prime=orpol(z,2);
   Y0=Y*P_prime;
   print 'P prime matrix',P_prime;
   t=y0||x||gr;
   /* Create New Transformed data set */
   varnames={yt1 yt2 yt3 x1 x2 x3 group};
   create trans from t (|colname=varnames|);
   append from t;
quit;
proc print data=trans;
run;

/* Test model fit  */
proc glm data=trans;
   title2 ' Test of Model Fit';
   model yt3=/nouni;
   manova h=intercept;
run;

/* Using a Rao-Khatri MANCOVA model                         */
/* Test for group differences, parallelism and  estimate  B */
proc glm data=trans;
title2 'Test of Group Differences (Coincidence) and Parallelism';
   class group;
   model yt1 - yt2 = group yt3;
   manova h=group/printh printe;
   manova h=group m=(0 1) prefix=parll/printe printh;
   estimate 'beta1' intercept 1 group 1 0 0;
   estimate 'beta2' intercept 1 group 0 1 0;
   estimate 'beta3' intercept 1 group 0 0 1;
run;
/* Estimate of B using syslin procedure */
proc syslin sur data=trans;
   title2 'Estimate of B using PROC SYSLIN';
   yt1:  model yt1 = x1 x2 x3 yt3/noint;
   yt2:  model yt2 = x1 x2 x3 yt3/noint;
   coin: stest yt1.x1=yt1.x2=yt1.x3,
               yt2.x1=yt2.x2=yt2.x3;
   parl: stest yt2.x1=yt2.x2=yt2.x3;
run;
