/*********************************************/
/* Program m5_9_1.sas                        */
/* Testing for Nonadditivity                 */
/* Tukey's Univariate Test                   */
/* Using the Ancova model approach           */
/*********************************************/

options ls = 80 nodate pageno=1 formdlim='o';

/* ANCOVA design for Nonaddivity*/
data add;
Title1 ' 2 X 3 Randomized Block Design';
   infile 'e:\add.dat';
   input B  T  f s zf zs;
proc print data=add;

proc glm data=add;
title2 ' Testing for Univariate Additivity five-letter variable f';
     class T B;
     model f = B T zf/ss3;
run;
proc glm data=add;
title2 ' Testing for Univariate Additivity seven-letter variable s';
     class T B;
     model s = B T zs/ss3;
run;
/*********************************************/
/* Testing for Nonadditivity                 */
/* Tukey's Multivariate Test                 */
/* Using the MANCOVA model approach          */
/*********************************************/

/* MANCOVA design for Nonaddivity  */
data add2;
Title1 '4 X 4 Multivariate Randomized Block Design';
   infile 'e:\add2.dat';
   input SES Ethnic Mat Eng GK mz ez gz;
proc print data=add2;

proc glm data=add2;
title1 ' Testing for Multivariate Additivity each variable';
     class SES Ethnic;
     model Mat Eng Gk =SES Ethnic mz ez gz/nouni ss3;
	 manova h=mz ez gz/printe printh;
run;
proc transreg data=add2 ss2 short;
     model identity(Mat Eng Gk mz ez gz)=class(Ses Ethnic/effects);
     output out=new;
run;
proc print data=new;
title2 'Test all covariates simultaneously zero';
proc reg data=new;
model Mat Eng Gk=Ses1 ses2 ses3
                 Ethnic1 Ethnic2 Ethnic3 
                 mz ez gz;
gamma_0: mtest mz, ez, gz/print;
MZ:mtest mz;
Ez:mtest ez;
gz:mtest gz;
run;
