/********************************************************/
/* Program m6_4_1.sas                                   */
/* Random Coefficient Regression Model                  */
/* Comparison with ANCOVA Mixed Model and Fixed Model   */
/* Obenchain(1990)--- Modification of Dataset           */
/********************************************************/

options ls=80 nodate pageno=1 formdlim='o';
title1 ' Obenchain(1990) ';

data rc;
   input batch month @@;
      monthc=month;
   do rep = 1 to 6;
      input y @@;
      output;
   end;
datalines;
1  0 101.2 103.3 103.3 102.1 104.4 102.4
1  1  98.8  99.4  99.7  99.5    .     .
1  3  98.4  99.0  97.3  99.8    .     .
1  6 101.5 100.2 101.7 102.7    .     .
1  9  96.3  97.2  97.2  96.3    .     .
1 12  97.3  97.9  96.8  97.7  97.7  96.7
2  0 102.6 102.7 102.4 102.1 102.9 102.6
2  1  99.1  99.0  99.9 100.6    .     .
2  3 105.7 103.3 103.4 104.0    .     .
2  6 101.3 101.5 100.9 101.4    .     .
2  9  94.1  96.5  97.2  95.6    .     .
2 12  93.1  92.8  95.4  92.2  92.2  93.0
3  0 105.1 103.9 106.1 104.1 103.7 104.6
3  1 102.2 102.0 100.8  99.8    .     .
3  3 101.2 101.8 100.8 102.6    .     .
3  6 101.1 102.0 100.1 100.2    .     .
3  9 100.9  99.5 102.2 100.8    .     .
3 12  97.8  98.3  96.9  98.4  96.9  96.5
;
proc print data=rc;
run;
proc plot;
   title2 'Profiles';
   plot y*month=Batch;
run;
title2 ' RC Model Random slopes and Intercepts --- Unknown Structure';
proc mixed data=rc method=reml covtest cl alpha=.10;
   class Batch ;
   model y=Month/solution outp=predu ddfm=satterth;
   random int month/type=un sub=batch solution cl alpha=.0083;
run;
   title2 'Residual analysis RC model Unknown Structure --- Outliers';
proc print data=predu;
run;
proc plot data=predu;
     plot pred*resid;
run;
proc univariate data=predu normal plot;
     var resid;
	 qqplot /normal (mu=est sigma=est);
run;
title2 ' RC Model Random slopes and Intercepts --- Compound Sym Structure';
proc mixed data=rc method=reml covtest cl alpha=.10;
   class Batch monthc;
   model y=Month /solution;
   random month/ sub=batch solution cl alpha=.0167;
   repeated/type=cs sub=monthc(batch);
run;
title2 ' RC Model Random slopes and Intercepts --- VC Structure';
proc mixed data=rc method=reml covtest cl alpha=.10;
   class Batch ;
   model y=Month/solution outp=predv ddfm=satterth;
   random int month/type=vc sub=batch solution cl alpha=.0083;
run;
   title2 'Residual analysis RC model VC Structure --- Outliers';
proc plot data=predv;
     plot pred*resid;
run;
proc univariate data=predv normal plot;
     var resid;
	 qqplot /normal (mu=est sigma=est);
run;
title2 ' RC Model Random Intercepts Only --- Fixed Slopes';
title3 ' This is the Mixed ANCOVA Model -- Random Batch & Parallel Slopes';
proc mixed data=rc method=reml covtest cl alpha=.10;
   class Batch ;
   model y=Month/solution  ddfm=satterth;
   random int /type=vc sub=batch solution cl alpha=.0167;
run;
title3 ' ';
Title2 'ANCOVA Model Random Batches and Fixed Parallel Slopes';
proc mixed data=rc method=reml covtest cl alpha=.10;
     class batch;
     model y=month/ ddfm=satterth;
     random batch/sub=batch solution cl alpha=.0167;
     estimate 'intercept' intercept 1;
run;
title2 'ANCOVA Model with Fixed Batches and Fixed Parallel Slopes';
title3 'Because of noint option test of Batch is test equal means';
proc mixed data=rc;
     class batch;
     model y=batch month/noint ddfm=satterth;
     lsmeans batch/cl adjust=Scheffe;
     estimate 'intercept'  batch .33333 .33333 .33333;
run;
title3 ' ';
title2 'Ancova Model with Traditional test of Batch effects';
proc mixed data=rc;
     class batch;
     model y=batch month /ddfm=satterth;
     lsmeans batch/cl adjust=Scheffe;
run;

title2 'Test of Parallelism for ANOVA Model';
title3 'Must only use test of interaction';
proc mixed data=rc;
     class batch;
     model y=batch month  batch*month;
run;
