/******************************************************/
/* Program m6_4_2.sas                                 */
/* Mixed Model Generalized Randomized Block Design    */
/* Example from  Milliken and Johnson(1992,page 290)  */
/* Analysis of Messy Data, Chapman & Hall             */
/*                                                    */
/* Example of Non-orthogonal Model III ANOVA with     */
/* Treatments Fixed and Blocks Random                 */
/*                                                    */
/*                                                    */
/******************************************************/

Options LS=80 nodate pageno=1 formdlim='o';
DATA ogrb;
     input treat block score @@;
     datalines;
     1 1 52.0 1 1 52.8 1 1 53.1
     1 2 51.8 1 2 52.8 1 2 53.1
     1 3 60.0 1 3 60.2 1 3 58.4
     1 4 51.1 1 4 52.3 1 4 50.3
     1 5 50.9 1 5 51.8 1 5 51.4
     1 6 46.4 1 6 44.8 1 6 49.2
     2 1 62.1 2 1 62.6 2 1 64.0
     2 2 59.7 2 2 60.0 2 2 59.0
     2 3 68.6 2 3 65.8 2 3 69.7
     2 4 63.2 2 4 62.8 2 4 62.2
     2 5 64.8 2 5 65.0 2 5 65.4
     2 6 43.7 2 6 44.2 2 6 43.0
     3 1 67.5 3 1 67.2 3 1 66.9
     3 2 61.5 3 2 61.7 3 2 62.3
     3 3 70.8 3 3 70.6 3 3 71.0
     3 4 64.1 3 4 66.2 3 4 64.0
     3 5 72.1 3 5 72.0 3 5 71.1
     3 6 62.0 3 6 61.4 3 6 60.5
;
Title1 'Orthogonal Two-Factor Model III ANOVA Model';

proc glm data=ogrb;
Title1 'Model III Approach where block*treatment Random';
     class block treat;
     model score = treat|block;
     random block block*treat/test;
run;
proc mixed data=ogrb method=reml covtest alpha=.05 cl;
title1 ' Proc mixed analyis of Mixed model III ANOVA';
     class block treat;
     model score = treat/ ddfm=satterth;
     lsmeans treat/pdiff=all cl  adjust=tukey;
     random block block*treat/solution cl;
     contrast 'treat'   treat 1 -1  0,
                        treat 0  1 -1/chisq;
run;
DATA ngrb;
     input treat block score @@;
     datalines;
     1 1 52.0
     1 2 51.8 1 2 52.8
     1 3 60.0
     1 4 51.1 1 4 52.3
     1 5 50.9 1 5 51.8 1 5 51.4
     1 6 46.4 1 6 44.8 1 6 49.2
     2 1 64.0
     2 2 59.7 2 2 60.0 2 2 59.0
     2 3 68.6 2 3 65.8
     2 4 63.2 2 4 62.8 2 4 62.2
     2 5 64.8 2 5 65.0
     2 6 43.7 2 6 44.2 2 6 43.0
     3 1 67.5 3 1 67.2 3 1 66.9
     3 2 61.5 3 2 61.7 3 2 62.3
     3 3 70.8 3 3 70.6 3 3 71.0
     3 4 64.1 3 4 66.2 3 4 64.0
     3 5 72.1 3 5 72.0 3 5 71.1
     3 6 62.0 3 6 61.4 3 6 60.5
;
Title1 ' Non-Orthogonal Two-Factor Model III ANOVA Model';


proc glm data=ngrb;
Title1 'Non-Orthogonal Model III Approach where block*treatment Random';
     class block treat;
     model score = treat|block;
     random block block*treat/test;
run;
proc mixed data=ngrb method=reml covtest alpha=.05 cl;
title1 ' Non-orthogonal proc mixed analyis of Mixed model III ANOVA';
     class block treat;
     model score = treat/ ddfm=satterth;
     lsmeans treat/pdiff=all cl  adjust=tukey;
     random block block*treat/solution cl;
     contrast 'treat'   treat 1 -1  0,
                        treat 0  1 -1/chisq;
run;
