/******************************************************/
/* Program m6_4_3.sas                                 */
/* Repeated Measurements with unequal numbers         */
/* Example from  Milliken and Johnson(1992,page 385)  */
/* Analysis of Messy Data, Chapman & Hall             */
/*                                                    */
/* Example of Non-orthogonal Model III Split-Plot     */
/* Design                                             */
/*                                                    */
/*                                                    */
/******************************************************/

Options LS=80 nodate pageno=1 formdlim='o';
DATA split;
     input treat patient week score;
     datalines;
     1 1 1 24
     1 1 2 18
     1 2 1 22
     2 3 1 25
     2 3 2 22
     2 4 1 23
     2 5 1 26
     2 5 2 24
;
Title1 'Nonorthogonal Split Plot Repeated Measures Design';
proc print data=split;
title2 'Glm ANOVA';
proc glm data=split;
     class treat patient week;
     model score = treat patient(treat) week treat*week;
     random patient(treat)/test;
run;
title2 'Mixed ANOVA';
proc mixed data=split method=reml covtest alpha=.05 cl;
     class patient treat week;
     model score = treat week treat*week/ ddfm=satterth;
     lsmeans treat/pdiff=all cl;
     lsmeans  week/pdiff=all cl;
     estimate 'interaction' treat*week 1 -1 -1 1;
     contrast 'interaction' treat*week 1 -1 -1 1;
     repeated/type=cs subject=patient(treat);
run;
