/*************************************************/
/* Program m6_6_1.sas                            */
/* Two-Way Mixed MANOVA Model                    */
/* Data from Khuri et al.(1998,page 274)         */
/*************************************************/

options ls=80 nodate pageno=1 formdlim='o';
title1 'Two-Way Mixed MANOVA';

data Khuri;
   infile 'e:\Khuri.dat';
   input A B y1 y2;
proc print data=Khuri;
run;
proc glm;
   title2 'Unweighted Analysis Random Model III MANOVA';
   class  A B;
   model y1 y2  = A B A*B/nouni;
   random B A*B/test;
   manova h= A*B;
   manova h=A B  e=A*B;
run;
proc glm;
   title2 'Unweighted Analysis Random Model II MANOVA';
   class  A B;
   model y1 y2  = A B A*B/nouni;
   random A B A*B /test;
   manova h= A*B;
   manova h=A B  e=A*B;
run;
