/********************************************************************/
/* Program m6_6_2.sas                                                */
/* Multivariate Split Plot Design                                   */
/* Example from Timm(1980) and Boik(1988,1991)                      */
/* Dr Thomas Zullo dental dataset                                   */
/********************************************************************/

options ls=80 nodate pageno=1 formdlim='o';

/* Multivariate Mixed Model Analysis */
data mix;
   infile 'e:\mixed.dat';
   input group subj cond SOR_Me ANS_Me Pal_MP;
proc print data=mix;
run;

proc glm data=mix;
   title2 'Multivaraiate Mixed Model Analysis';
   class group subj cond;
   model SOR_Me ANS_Me Pal_MP = group subj(group) cond cond*group;
   random subj(group);
   manova h = cond group*cond/ printh printe;
   manova h = group e=subj(group);
run;

proc mixed data=mix cl;
    title2 ' Mixed model for varaiable SOR_Me';
    class group subj cond;
    model SOR_Me = group cond cond*group;
    random subj(group);
    lsmeans cond/pdiff cl alpha=.0167 adjust=Bon;
run;
proc mixed data=mix cl;
    title2 ' Mixed model for varaiable ANS_Me';
    class group subj cond;
    model ANS_Me = group cond cond*group;
    random subj(group);
    lsmeans cond/pdiff cl alpha=.0167 adjust=Bon;
run;
proc mixed data=mix cl;
    title2 ' Mixed model for varaiable Pal_MP';
    class group subj cond;
    model Pal_MP = group cond cond*group;
    random subj(group);
    lsmeans cond/pdiff cl alpha=.0167 adjust=Bon;
run;
