/********************************************************************/
/* Program m6_8_1.sas                                                */
/* Example from Timm(1980b) and Boik(1988,1991)                     */
/* Dr Thomas Zullo Dental dataset                                   */
/* Analysis using Double Multivariate Linear Model                  */
/* Multivariate Tests and epsilon-adjusted Tests                    */
/* Also included is Multivariate Mixed Model Analysis               */
/* With Test of Multivariate Sphericity                             */
/********************************************************************/

options ls=80  nodate pageno=1 formdlim='o';
title 'Double Multivariate Model--- DMM Analysis';

data dmlm;
   infile 'e:\zullo.dat';
   input group y1 - y9;
proc print data=dmlm;
run;
/* Multivariate test of Group Means*/
proc glm;
   title2 ' Test of H:G* --- Equal Mean Vectors';
   class group;
   model y1 - y9 = group/ nouni;
   means group;
   manova  h=group/ printh printe;
run;

/* Multivariate test of Parallelism */
proc glm;
   title2 ' Test of H:GC --- Test of Interaction or Parallelism';
   class group;
   model y1 - y9 = group / nouni;
   contrast 'Parallel'
             group 1 -1;
   manova m=(.7071 0 -.7071 0 0 0 0 0 0,
             0 0 0 -.408 .816 -.408 0 0 0,
             0 0 0 0 0 0 .7071 0 -.7071,
             -.408 .816 -.408 0 0 0 0 0 0,
             0 0 0 .7071 0 -.7071 0 0 0,
             0 0 0 0 0 0 -.408 .816 -.408) prefix = parl/ printh printe;
run;

/* Multivariate test of Conditions as vectors */
proc glm;
   title2 'Test of H:C* ---  Multivariate Test of Conditions';
   class group;
   model y1 - y9 = group/ noint nouni;
   contrast 'Mult Cond' group 1 0,
                        group 0 1;
   manova m=(1 -1 0 0 0 0 0 0 0,
             0 1 -1 0 0 0 0 0 0,
             0 0 0 1 -1 0 0 0 0,
             0 0 0 0 1 -1 0 0 0,
             0 0 0 0 0 0 1 -1 0,
             0 0 0 0 0 0 0 1 -1) prefix = diff/ printh printe;
run;

/* Multivariate test of Conditions given Parallelism */
proc glm;
     title2 'Test of H:C ---  Test of Conditions given Parallelism';
   class group;
   model y1- y9 = group/noint nouni;
   contrast 'Cond|Parl' group .5 .5;
   manova m=(.7071 0 -.7071 0 0 0 0 0 0,
             0 0 0 -.408 .816 -.408 0 0 0,
             0 0 0 0 0 0 .7071 0 -.7071,
             -.408 .816 -.408 0 0 0 0 0 0,
             0 0 0 .7071 0 -.7071 0 0 0,
             0 0 0 0 0 0 -.408 .816 -.408) prefix=cond/ printh printe;
run;

proc glm;
   title2 ' Test H:G Group Means given Parallelism';
   class group;
   model y1 - y9 = group/noint nouni;
   contrast 'Group|Parl' group 1 -1;
   manova m=(.577 .577 .577 0 0 0 0 0 0,
             0 0 0 .577 .577 .577 0 0 0,
             0 0 0 0 0 0 .577 .577 .577) prefix=ovall/ printh printe;

/* Multivariate Mixed Model Analysis */
data mix;
title2 'MMM Split-Plot Analysis';
   infile 's:\mixed.dat';
   input group subj cond y1 y2 y3;
proc print data=mix;
run;

proc glm;
   class group subj cond;
   model y1 - y3 = group subj(group) cond cond*group/nouni;
   random subj(group);
   manova h = cond group*cond/ printh printe;
   manova h = group e=subj(group);
run;

/* Test for Multivariate Spericity and calculation of Epsilon for MMM*/

proc iml;
   print 'Test of Multivariate Sphericity Using Chi-Square and Adjusted Chi-
          Square Statistics';
   e={  9.6944  7.3056  -6.7972 -4.4264 -0.6736   3.7255,
        7.3056  8.8889  -4.4583 -3.1915 -3.2396   2.9268,
       -6.7972 -4.4583  18.6156  2.5772  0.8837 -10.1363,
       -4.4264 -3.1915   2.5772  5.3981  1.4259  -1.8546,
       -0.6736 -3.2396   0.8837  1.4259 18.3704   -.7769,
        3.7255  2.9268 -10.1363 -1.8546 -0.7769   6.1274};
   print e;
   n=18;
   p=3;
   t=3;
   k=2;
   u=6;
   q=u/p;
   nu_e=n-k;
   nu_h=1;
   e11=e[1:3,1:3];print e11;
   e22=e[4:6,4:6];print e22;
   dn=(e11+e22)/2;
   b=eigval(dn); print b;
   a=eigval(e); print a;
   b=log(b);
   a=log(a);
   chi_2=n#(q#sum(b)-sum(a));
   df=p#(q-1)#(p#q+p+1)/2;
   pvalue=1-probchi(chi_2,df);
   print chi_2 df pvalue;
   c1=p/(12#q#nu_e#df);
   rho= 1-c1#(2#p##2#(q##4-1)+3#p#(q##3-1)-(q##2-1));
   ro_chi_2=(rho#nu_e/n)#chi_2; print rho;
   c2=1/(2#rho##2);
   c3=((p#q-1)#p#q#(p#q+1)#(p#q+2))/(24#nu_e##2);
   c4=((p-1)#p#(p+1)#(p+2))/(24#q##2#nu_e##2);
   c5=df#(1-rho)##2/2;
   omega=c2#(c3-c4-c5); print omega;
   p1=1-probchi(ro_chi_2,df);
   p2=1-probchi(ro_chi_2,df+4);
   cpvalue=(1-omega)#p1+omega#p2;
   print ro_chi_2 cpvalue;

   s=e/nu_e;
   s11=s[1:3,1:3]; s12=s[1:3,4:6];
   s21=s[4:6,1:3]; s22=s[4:6,4:6];
   enum=trace((s11+s22)*(s11+s22))+(trace(s11+s22))##2;
   eden=q#( trace(s11)##2+trace(s11*s11)+trace(s12)##2+trace(s12*s12)+
            trace(s21)##2+trace(s21*s21)+trace(s22)##2+trace(s22*s22));
   epsilon=enum/eden;print enum eden;

   nu_h=nu_h#q; nu_e=nu_e#q; s0=min(nu_h,p);
   Mnu_h=nu_h#epsilon; Mnu_e=nu_e#epsilon; ms0=min(mnu_h,p);
   m0=(abs(mnu_h-p)-1)/2; n0=(mnu_e-p-1)/2;

   denom=s0##2#(2#m0+ms0+1); numer=2#(ms0#n0+1);
   df1=ms0#(2#m0+ms0+1); df2=2#(ms0#n0+1);

   print 'Epsilon adjusted using results in Boik(1988)';
   print epsilon;
   f_cond = df2#13.75139851/(ms0#df1);
   f_gXc  = df2#0.19070696/(ms0#df1);
   print f_cond f_gXc df1 df2;
   p_cond=1-probf(f_cond,df1,df2);
   p_gXc=1-probf(f_gXc,df1,df2);

   print 'Epsilon adjusted p-values for MMM tests using T0**2 Criterion Boik(1988)';

   print p_cond p_gXc;


   t11=trace(s11);t12=trace(s12);t21=trace(s21);t22=trace(s22);
   tp={0 0,
      0 0};
   tp[1,1]=t11; tp[1,2]=t12;
   tp[2,1]=t21; tp[2,2]=t22;

   print tp;
   call eigen(m,v,tp);
   tp_=v*sqrt(diag(m));
   phi=(i(3)@tp_)*e*(i(3)@tp_);print phi;
   print 'Epsilon adjusted using results in Boik(1991)';
   newepi=((trace(phi))**2/trace(phi)**2)/p*(t-1);
   print newepi;
  Mnu_h=nu_h#newepi; Mnu_e=nu_e#newepi; ms0=min(mnu_h,p);
   m0=(abs(mnu_h-p)-1)/2; n0=(mnu_e-p-1)/2;

   denom=s0##2#(2#m0+ms0+1); numer=2#(ms0#n0+1);
   df1=ms0#(2#m0+ms0+1); df2=2#(ms0#n0+1);


   f_cond = df2#13.75139851#newepi/(ms0#df1);
   f_gXc  = df2#0.19070696#newepi/(ms0#df1);
   print f_cond f_gXc df1 df2;
   p_cond=1-probf(f_cond,df1,df2);
   p_gXc=1-probf(f_gXc,df1,df2);

   print 'Epsilon adjusted p-values for MMM tests using T0**2 Criterion Boik(1991)';

   print p_cond p_gXc;
quit;
