/*****************************************************/
/* Program m6_8_2.sas                                */
/* Analysis of Multivariate repeated Measurements    */
/* With Kronecker Product Structure Using Proc Mixed */
/* Split-Split Plot Design                           */
/*****************************************************/

options ls=80 nodate formdlim='o';

data Kron;
     infile 'e:\kron.dat';
     input treat $ subj@;
     do B = 1 to 3;
     do C  =  1 to 3;
     input y @;output;
     end;
     end;
run;
title 'Mixed Model with Kronecker Product Covariance Structure';
proc print data=Kron;
run;
proc mixed data=Kron method=ml cl;
title2 ' Within Unknown Kronecker Structure';
     class treat b c;
     model y= treat b c b*c treat*b treat*c treat*b*c/ddfm=satterth;
     lsmeans treat/pdiff cl;
     contrast 'inter1' b*c 1 -1 0 -1 1 0 0 0 0;
     estimate 'inter1' b*c 1 -1 0 -1 1 0 0 0 0;
     contrast 'inter2' b*c 0 1 -1 0 -1 1 0 0 0;
     estimate 'inter2' b*c 0 1 -1 0 -1 1 0 0 0;
     contrast 'inter3' b*c 0 0 0 1 -1 0 -1 1 0;
     estimate 'inter3' b*c 0 0 0 1 -1 0 -1 1 0;
     contrast 'inter4' b*c 0 0 0 0 1 -1 0 -1 1;
     estimate 'inter4' b*c 0 0 0 0 1 -1 0 -1 1;
     repeated b c/type=un@un subject=subj r;
run;
proc mixed data=Kron method=ml cl;
title2 ' Within Compound-Symmetry Kronecker Structure';
     class treat b c;
     model y= treat b c b*c treat*b treat*c treat*b*c/ddfm=satterth;
     repeated b c/type=un@cs subject=subj r;
run;
proc glm data=Kron;
title2 ' Univariate Mixed Model Analysis using Proc Glm and Compound Symmetry';
     class treat subj b c;
     model y= treat b c b*c treat*b treat*c treat*b*c
               subj(treat) b*subj(treat) c*subj(treat);
     random subj(treat) b*subj(treat) c*subj(treat)/test;
run;
proc mixed data=Kron method=ml cl;
title2 ' Univariate Mixed Model Analysis using Proc Mixed and Compound Symmetry';
     class treat subj b c;
     model y= treat b c b*c treat*b treat*c treat*b*c/ddfm=contain;
     lsmeans treat/pdiff cl;
     contrast 'inter1' b*c 1 -1 0 -1 1 0 0 0 0;
     estimate 'inter1' b*c 1 -1 0 -1 1 0 0 0 0;
     contrast 'inter2' b*c 0 1 -1 0 -1 1 0 0 0;
     estimate 'inter2' b*c 0 1 -1 0 -1 1 0 0 0;
     contrast 'inter3' b*c 0 0 0 1 -1 0 -1 1 0;
     estimate 'inter3' b*c 0 0 0 1 -1 0 -1 1 0;
     contrast 'inter4' b*c 0 0 0 0 1 -1 0 -1 1;
     estimate 'inter4' b*c 0 0 0 0 1 -1 0 -1 1;
     random subj(treat) b*subj(treat) c*subj(treat);
run;

/* MANOVA model*/
data dmm;
     infile 's:kron.dat';
     input treat $ subj y1 -y9;
run;
title2 ' Multivariate Linear Model with Unknown Covariance Matrix';
proc glm data=dmm;
     class treat;
     model y1 -y9 = treat/nouni noint;
     contrast 'Parl' treat 1 -1;
     manova m =(1  1  1 -1 -1 -1  0  0  0,
                0  0  0  1  1  1 -1 -1 -1,
                1 -1  0  1 -1  0  1 -1  0,
                0  1 -1  0  1 -1  0  1 -1,
                1 -1  0 -1  1  0  0  0  0,
                0  1 -1  0 -1  1  0  0  0,
                0  0  0  1 -1  0 -1  1  0,
                0  0  0  0  1 -1  0 -1  1) prefix=parl;
     contrast 'bc|Parl' treat 1 1;
     manova m =(1 -1 0 -1 1 0 0 0 0,
                0 1 -1 0 -1 1 0 0 0,
                0 0 0 1 -1 0 -1 1 0,
                0 0 0 0 1 -1 0 -1 1) prefix=bc;
     contrast 'a' treat 1 -1;
     manova m= (1 1 1 1 1 1 1 1 1) prefix=a;
     contrast 'b' treat 1 1;
     manova m= (1 1 1 0 0 0 -1 -1 -1,
                0 0 0 1 1 1 -1 -1 -1) prefix=b;
     contrast 'c' treat 1 1;
     manova m=(1 0 -1 1 0 -1 1 0 -1,
               0 1 -1 0 1 -1 0 1 -1) prefix=c;

run;
Title2 'Test of Treatment Means and Estimate of Omega';
proc glm data=dmm;
     class treat;
     model y1 - y9 = treat/ nouni;
     means treat;
     manova h=treat/printh printe;
run;
title2 ' ';
/* Test of Kronecker Structure */
proc iml;
print 'Test for Kronecker Structure vs General structure';
     n=20;
     p=3;
     t=3;
     n_p=n*p;
     n_t=n*t;
     sigmap={77.281  12.964  10.163,
             12.964 358.750  15.271,
             10.163  15.271  47.225};
     sigmat={ 1.0000  0.6876 0.3334,
              0.6876  0.6169 0.4636,
              0.3334  0.4636 0.5514};

          e={2546.9 1583.1   597  766.6  946.6  588.9  257.9 337.5 385.9,
             1583.1 1193.3 783.4    772  769.6  482.5  214.3 283.3 335.5,
                597  783.4 960.4  761.6  569.2  357.4  155.2 228.8 299.4,
              766.6    772 761.6 1051.3 1364.2  886.2  417.4 438.7 444.2,
              946.6  769.6 569.2 1364.2   2204 1440.8  686.2 657.4 599.8,
              588.9  482.5 357.4  886.2 1440.8 1165.3  908.1 753.3 575.3,
              257.9  214.3 155.2  417.4  686.2  908.1 1164.5 876.9 573.1,
              337.5  283.3 228.8  438.7  657.4  753.3  876.9 818.6 741.3,
              385.9  335.5 299.4  444.2  599.8  575.3  573.1 741.3 899.3};
      omega=e/(n-2);
print omega;
      num=det(omega)**(n/2);

      den=(det(sigmap)**(n_p/2))*(det(sigmat)**(n_t/2));

      lamda=-2*log(num/den);

      df=(p-1)*(t-1)*((p+1)*(t+1)+1)/2;

      crit_v=cinv(.95,df);

      p_value=1-probchi(lamda,df);

print lamda df;

print 'Chi-square critical value=' crit_v;

print 'p-value for test of Kronecker Struture=' p_Value;
quit;
