/****************************************************************/
/* Program m7_3_1.sas                                           */
/* Discriminant Analysis for Separation/Classification          */
/* Egyptian Skulls Data                                         */
/* Reference: Thomson and Randall-Maciver(1905)                 */
/* Source:http://lib.stat.cmu.edu/DASL/Datafiles/EgyptianSkulls */
/****************************************************************/

Options ls=80 nodate pageno=1 formdlim='o';
filename multnorm 'e:\multnorm.sas';
%include multnorm;

Title 'Two Group Discriminant Analysis';

Data Skulls;
     Infile 'e:\Skulls.dat';
     Input MB BH BL NH Year;
     If Year <= -200 then group = 1;
     If Year >=  150 then group = 2;
proc print data=Skulls;
run;
/* Normality of Sample */
%multnorm(data=Skulls,
          var=MB BH BL NH,
          plot=yes);
run;
title2 'Test of Location using Manova';
proc glm data=Skulls;
     class group;
     model MB BH BL NH = group/nouni;
     manova h=group/printe printh canonical;
run;

title2 'Canonical Discriminant Analysis';
proc candisc data=skulls out=outcan distance;
     class group;
     var MB BH BL NH;
run;
title2 'Histogram of Canonical Variate';
proc chart data=outcan;
     vbar can1 /group=group;
run;
title2 'Univariate t-test of Discriminant Scores';
proc ttest data=outcan;
     class group;
     var can1;
run;
title2 'Stepwise Discriminant Analysis';
proc stepdisc data=skulls method=backward;
     class group;
     var MB BH BL NH;
run;
title2 'Classification Analysis all Variables';
proc discrim data=skulls pool=test simple manova method=normal
     crossvalidate crosslisterr;
     class group;
     var MB BH BL NH;
run;
title2 'Classification Analysis --- Subset of Variables';
proc discrim data=skulls pool=test simple manova method=normal
     crossvalidate crosslisterr;
     class group;
     var MB BH BL;
run;
title2 'Canonical Discriminant Analysis --- Subset of Variables';
proc candisc data=skulls distance;
     class group;
     var MB BH BL;
run;
