/****************************************************************/
/* Program m7_3_2.sas                                           */
/* Discriminant Analysis for Separation/Classification          */
/* Brain Size Data                                              */
/* Reference: Willerman et al. (1991)                           */
/* Source:http://lib.stat.cmu.edu/DASL/Datafiles/Brainsize      */
/****************************************************************/

Options ls=80 nodate pageno=1 formdlim='o';
filename multnorm 'e:\multnorm.sas';
%include multnorm;

Title 'Two Group Discriminant Analysis';

Data Brain;
     Infile 'e:\Brainsize.dat';
     Input Gender $ FSIQ VIQ PIQ Weight Height MRI;
     If Gender='Male'   then group = 1;
     If Gender='Female' then group = 2;
run;
/* Normality of Sample */
%multnorm(data=Brain,
          var=FSIQ VIQ PIQ Weight Height MRI,
          plot=yes);
run;
proc sort data=brain;
     by group;
run;
proc print data=brain;
title2 'Test of Location using Manova';
proc glm data=Brain;
     class group;
     model FSIQ VIQ PIQ Weight Height MRI = group/nouni;
     manova h=group/printe printh canonical;
run;

title2 'Canonical Discriminant Analysis';
proc candisc data=Brain out=outcan distance;
     class group;
     var FSIQ VIQ PIQ Weight Height MRI;
run;
title2 'Histogram of Canonical Variate';
proc chart data=outcan;
     vbar can1 /group=group;
run;
title2 'Stepwise Discriminant Analysis';
proc stepdisc data=Brain method=backward;
     class group;
     var FSIQ VIQ PIQ Weight Height MRI;
run;
title2 'Linear Classification Analysis all Variables';
proc discrim data=Brain pool=test simple method=normal
     crossvalidate crosslisterr;
     class group;
     var FSIQ VIQ PIQ Weight Height MRI;
run;
title2 'Quadratic Classification Analysis all Variables';
proc discrim data=Brain pool=no simple method=normal
     crossvalidate crosslisterr;
     class group;
     var FSIQ VIQ PIQ Weight Height MRI;
run;
