/****************************************************************/
/* Program m7_5_1.sas                                           */
/* Discriminant Analysis for Separation/Classification          */
/* Flea Beetles Data                                            */
/* Reference: Lubischew(1962)                                   */
/* Source:http://lib.stat.cmu.edu/DASL/Datafiles/FleaBeetles    */
/****************************************************************/

Options ls=80 nodate pageno=1 formdlim='o';
filename multnorm 'e:\multnorm.sas';
%include multnorm;

Title 'Multiple Group Discriminant Analysis';

Data Beetles;
     Infile 'e:\Fleabeetles.dat';
     Input Width Angle Species $;
     If Species='Con' then group=1;
     If Species='Hei' then group=2;
     If Species='Hep' then group=3;
run;
data CON1 HEI2 HEP3;
     set Beetles;
	 If group=1 then output CON1;
	 If group=2 then output HEI2;
	 If group=3 then output HEP3;
run;

proc print data=beetles;
run;
title2 'Test of Locations using Manova';
proc glm data=Beetles;
     class Species;
     model Width Angle = Species/nouni;
     means Species;
     manova h=Species/printe printh canonical;
run;
title2 'Canonical Discriminant Analysis';
proc candisc data=beetles out=outcan distance pcov;
     class species;
     var Width Angle;
run;
proc format;
value  spec 1='C' 2='H' 3='P';
run;
title2 'Hitogram of First Canonical Variate';
proc chart data=outcan;
    vbar can1/group=species;
    vbar can2/group=species;
run;
proc gplot data=outcan;
     plot can2*can1=group;
     format group spec.;
	 symbol1 v='C' c=red;
	 symbol2 v='H' c=green;
	 symbol3 v='P' c=blue;

title2 'Plot of Canonical Discriminant Functions';
run;
title2 'Stepwise Discriminant Analysis';
proc stepdisc data=beetles method=backward;
     class species;
     var Width Angle;
run;
title2 'Classification Analysis All Variables';
proc discrim data=beetles pool=test simple manova wcov method=normal 
     outstat=coeffs crossvalidate;
     class species;
     var Width Angle;
run;

/* Extract Coefficients  */
data coeffs;
     set coeffs;
	 if _type_='LINEAR';
run;
proc print data=coeffs;
proc sort;
     by species _name_;
run;
data coeffs;
     set coeffs;
	 by species;
	 retain _const_;
     drop _name_;
	 if _name_='_CONST_'
      then do;
	  _const_=Width;
	     end;
	   else output;
run;
proc print data=coeffs;
proc transpose data=coeffs out=coefft;
     id species;
run;
data coefft;
     set coefft;
	 D12 = Con - Hei;
	 D13 = Con - Hep;
	 D23 = Hei - Hep;
data;
Title2 'D(i,j) Functions';
proc print data=coefft;
data coefft;
     set coefft;
	 drop Con Hei Hep;
run;
symbol1 v=dot c=black;
/* Normality */
%multnorm(data=CON1,
          var=width angle,  
          plot=yes);
run;
%multnorm(data=HEI2,
          var=width angle,
          plot=yes);
run;
%multnorm(data=HEP3,
          var=width angle,  
          plot=yes);
run;
